/*
 * Decompiled with CFR 0.152.
 */
package com.voxcrafterlp.cauldroninteract.utils.githubversionchecker;

import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.exceptions.InvalidVersionString;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReleaseVersion
implements Comparable<ReleaseVersion>,
Serializable {
    private int major = 0;
    private int minor = 0;
    private int patch = 0;

    public ReleaseVersion(int major) {
        this.major = major;
    }

    public ReleaseVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public ReleaseVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public ReleaseVersion(String versionString) {
        this.parseVersionString(versionString);
    }

    private void parseVersionString(String s) {
        Pattern pattern = Pattern.compile("[vV]?(\\d+)\\.?(\\d+)?\\.?(\\d+)?");
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (i == 1) {
                    this.major = Integer.parseInt(matcher.group(i));
                }
                if (i == 2) {
                    this.minor = Integer.parseInt(matcher.group(i));
                }
                if (i != 3) continue;
                this.patch = Integer.parseInt(matcher.group(i));
            }
        } else {
            throw new InvalidVersionString(s);
        }
    }

    @Override
    public int compareTo(ReleaseVersion other) {
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.format("v%d.%d.%d", this.major, this.minor, this.patch);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }
}

