/*
 * Decompiled with CFR 0.152.
 */
package com.twojapackage.ghostssmp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GhostsSMP
extends JavaPlugin
implements Listener,
TabExecutor {
    private final Map<Player, Long> dashCooldowns = new HashMap<Player, Long>();

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("GSMP").setExecutor((CommandExecutor)this);
        this.getCommand("GSMP").setTabCompleter((TabCompleter)this);
        new BukkitRunnable(){

            public void run() {
                String var10000 = String.valueOf(ChatColor.GREEN);
                Bukkit.broadcastMessage((String)(var10000 + String.valueOf(ChatColor.UNDERLINE) + String.valueOf(ChatColor.AQUA) + String.valueOf(ChatColor.RESET)));
            }
        }.runTaskTimer((Plugin)this, 0L, 3600L);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player deadPlayer = event.getEntity();
        Player killer = deadPlayer.getKiller();
        if (killer != null) {
            Random random = new Random();
            double chance = random.nextDouble();
            ItemStack soul = null;
            if (chance < 0.16) {
                soul = this.createSoul("Strength Soul", ChatColor.RED, Material.WHITE_DYE);
            } else if (chance < 0.32) {
                soul = this.createSoul("Sea Soul", ChatColor.AQUA, Material.WHITE_DYE);
            } else if (chance < 0.48) {
                soul = this.createSoul("Resistance Soul", ChatColor.GRAY, Material.WHITE_DYE);
            } else if (chance < 0.64) {
                soul = this.createSoul("Regeneration Soul", ChatColor.DARK_RED, Material.WHITE_DYE);
            } else if (chance < 0.68) {
                soul = this.createSoul("Cursed Soul", ChatColor.DARK_PURPLE, Material.PURPLE_DYE);
            } else if (chance < 0.715) {
                soul = this.createSoul("Dash Soul", ChatColor.DARK_BLUE, Material.BLUE_DYE);
            } else if (chance < 0.76) {
                soul = this.createSoul("Absorption Soul", ChatColor.YELLOW, Material.YELLOW_DYE);
            } else if (chance < 0.82) {
                soul = this.createSoul("Haste Soul", ChatColor.GOLD, Material.ORANGE_DYE);
            } else if (chance < 0.83) {
                soul = this.createSoul("Wind Soul", ChatColor.WHITE, Material.WHITE_DYE);
            }
            if (soul != null) {
                killer.getInventory().addItem(new ItemStack[]{soul});
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemMeta meta;
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && (item.getType() == Material.WHITE_DYE || item.getType() == Material.PURPLE_DYE || item.getType() == Material.BLUE_DYE || item.getType() == Material.YELLOW_DYE || item.getType() == Material.ORANGE_DYE) && item.hasItemMeta() && (meta = item.getItemMeta()) != null && meta.hasEnchant(Enchantment.UNBREAKING)) {
            String displayName = meta.getDisplayName();
            if (displayName.contains("Cursed Soul")) {
                this.applyCursedEffect(player);
                item.setAmount(item.getAmount() - 1);
                player.getInventory().setItemInMainHand(item);
                player.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "[GSMP] You have activated the Cursed Soul!");
                return;
            }
            if (displayName.contains("Dash Soul")) {
                if (this.isOnCooldown(player)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait before using this soul again!");
                    return;
                }
                this.dashPlayer(player);
                this.setCooldown(player);
                item.setAmount(item.getAmount() - 1);
                player.getInventory().setItemInMainHand(item);
                player.sendMessage(String.valueOf(ChatColor.DARK_BLUE) + "[GSMP] You have activated the Dash Soul!");
                return;
            }
            if (displayName.contains("Haste Soul")) {
                this.removeAllSoulsEffects(player);
                this.applyPotionEffect(player, PotionEffectType.HASTE, 1, Integer.MAX_VALUE);
                item.setAmount(item.getAmount() - 1);
                player.getInventory().setItemInMainHand(item);
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "[GSMP] You have activated the Haste Soul!");
                return;
            }
            if (displayName.contains("Wind Soul")) {
                this.applyWindSoulEffect(player);
                item.setAmount(item.getAmount() - 1);
                player.getInventory().setItemInMainHand(item);
                player.sendMessage(String.valueOf(ChatColor.WHITE) + "[GSMP] You have activated the Wind Soul!");
                return;
            }
            this.removeAllSoulsEffects(player);
            if (displayName.contains("Strength Soul")) {
                this.applyPotionEffect(player, PotionEffectType.STRENGTH, 1, Integer.MAX_VALUE);
            } else if (displayName.contains("Sea Soul")) {
                this.applyPotionEffect(player, PotionEffectType.DOLPHINS_GRACE, 1, Integer.MAX_VALUE);
            } else if (displayName.contains("Resistance Soul")) {
                this.applyPotionEffect(player, PotionEffectType.RESISTANCE, 1, Integer.MAX_VALUE);
            } else if (displayName.contains("Regeneration Soul")) {
                this.applyPotionEffect(player, PotionEffectType.REGENERATION, 2, Integer.MAX_VALUE);
            } else if (displayName.contains("Absorption Soul")) {
                this.applyPotionEffect(player, PotionEffectType.ABSORPTION, 4, 200);
            }
            item.setAmount(item.getAmount() - 1);
            player.getInventory().setItemInMainHand(item);
            String var10001 = String.valueOf(ChatColor.GREEN);
            player.sendMessage(var10001 + "[GSMP] You have activated the " + displayName + "!");
        }
    }

    private void applyPotionEffect(Player player, PotionEffectType type, int level, int duration) {
        player.addPotionEffect(new PotionEffect(type, duration, level), true);
    }

    private void removeAllSoulsEffects(Player player) {
        player.removePotionEffect(PotionEffectType.STRENGTH);
        player.removePotionEffect(PotionEffectType.DOLPHINS_GRACE);
        player.removePotionEffect(PotionEffectType.RESISTANCE);
        player.removePotionEffect(PotionEffectType.REGENERATION);
        player.removePotionEffect(PotionEffectType.ABSORPTION);
        player.removePotionEffect(PotionEffectType.HEALTH_BOOST);
    }

    private void applyCursedEffect(Player player) {
        for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 5.0, 5.0, 5.0)) {
            if (entity == player) continue;
            Vector direction = entity.getLocation().toVector().subtract(player.getLocation().toVector()).normalize().multiply(5);
            entity.setVelocity(direction);
            if (!(entity instanceof LivingEntity)) continue;
            ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 1200, 1));
        }
    }

    private void dashPlayer(Player player) {
        Vector direction = player.getLocation().getDirection().normalize().multiply(1);
        player.setVelocity(direction);
        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 60, 1, false, false));
    }

    private boolean isOnCooldown(Player player) {
        return this.dashCooldowns.containsKey(player) && System.currentTimeMillis() - this.dashCooldowns.get(player) < 5000L;
    }

    private void setCooldown(Player player) {
        this.dashCooldowns.put(player, System.currentTimeMillis());
    }

    private void applyWindSoulEffect(Player player) {
        Vector vector = player.getVelocity();
        vector.setY(2);
        player.setVelocity(vector);
        Vector randomOffset = new Vector(Math.random() * 10.0 - 5.0, 0.0, Math.random() * 10.0 - 5.0);
        player.teleport(player.getLocation().add(randomOffset));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 60, 4, false, false));
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 100, 0, false, false));
        for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 10.0, 10.0, 10.0)) {
            if (!(entity instanceof LivingEntity) || entity == player) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 1200, 3, false, false));
            Vector velocity = livingEntity.getVelocity();
            velocity.setY(2);
            livingEntity.setVelocity(velocity);
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, 3, false, false)), 1L);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("GSMP") && args.length == 3 && args[0].equalsIgnoreCase("give")) {
            if (sender.hasPermission("GGSMP.admin")) {
                String soulName = args[1].toLowerCase();
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target != null) {
                    ItemStack soul = null;
                    int var9 = -1;
                    switch (soulName.hashCode()) {
                        case -2140643535: {
                            if (!soulName.equals("strength_soul")) break;
                            var9 = 0;
                            break;
                        }
                        case -1489153693: {
                            if (!soulName.equals("absorption_soul")) break;
                            var9 = 6;
                            break;
                        }
                        case -1073206489: {
                            if (!soulName.equals("haste_soul")) break;
                            var9 = 7;
                            break;
                        }
                        case -1050498432: {
                            if (!soulName.equals("dash_soul")) break;
                            var9 = 5;
                            break;
                        }
                        case -231881782: {
                            if (!soulName.equals("wind_soul")) break;
                            var9 = 8;
                            break;
                        }
                        case -126578119: {
                            if (!soulName.equals("resistance_soul")) break;
                            var9 = 2;
                            break;
                        }
                        case 207575591: {
                            if (!soulName.equals("regeneration_soul")) break;
                            var9 = 3;
                            break;
                        }
                        case 871582691: {
                            if (!soulName.equals("sea_soul")) break;
                            var9 = 1;
                            break;
                        }
                        case 2039289856: {
                            if (!soulName.equals("cursed_soul")) break;
                            var9 = 4;
                        }
                    }
                    switch (var9) {
                        case 0: {
                            soul = this.createSoul("Strength Soul", ChatColor.RED, Material.WHITE_DYE);
                            break;
                        }
                        case 1: {
                            soul = this.createSoul("Sea Soul", ChatColor.AQUA, Material.WHITE_DYE);
                            break;
                        }
                        case 2: {
                            soul = this.createSoul("Resistance Soul", ChatColor.GRAY, Material.WHITE_DYE);
                            break;
                        }
                        case 3: {
                            soul = this.createSoul("Regeneration Soul", ChatColor.DARK_RED, Material.WHITE_DYE);
                            break;
                        }
                        case 4: {
                            soul = this.createSoul("Cursed Soul", ChatColor.DARK_PURPLE, Material.PURPLE_DYE);
                            break;
                        }
                        case 5: {
                            soul = this.createSoul("Dash Soul", ChatColor.DARK_BLUE, Material.BLUE_DYE);
                            break;
                        }
                        case 6: {
                            soul = this.createSoul("Absorption Soul", ChatColor.YELLOW, Material.YELLOW_DYE);
                            break;
                        }
                        case 7: {
                            soul = this.createSoul("Haste Soul", ChatColor.GOLD, Material.ORANGE_DYE);
                            break;
                        }
                        case 8: {
                            soul = this.createSoul("Wind Soul", ChatColor.WHITE, Material.WHITE_DYE);
                        }
                    }
                    if (soul != null) {
                        target.getInventory().addItem(new ItemStack[]{soul});
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Gave " + soulName + " to " + target.getName());
                    } else {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid soul name.");
                    }
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                }
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("give");
        } else if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            completions.add("strength_soul");
            completions.add("sea_soul");
            completions.add("resistance_soul");
            completions.add("regeneration_soul");
            completions.add("cursed_soul");
            completions.add("dash_soul");
            completions.add("absorption_soul");
            completions.add("haste_soul");
            completions.add("wind_soul");
        } else if (args.length == 3 && args[0].equalsIgnoreCase("give")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                completions.add(player.getName());
            }
        }
        return completions;
    }

    private ItemStack createSoul(String name, ChatColor color, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String var10001 = String.valueOf(color);
            meta.setDisplayName(var10001 + name);
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            item.setItemMeta(meta);
        }
        return item;
    }
}

