/*
 * Decompiled with CFR 0.152.
 */
package com.croaklib;

import com.croaklib.CroakLibMod;
import com.croaklib.screen.UpdateScreen;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;

public class ModUpdater {
    private static final int BUFFER_SIZE = 8192;
    private static final List<Updatable> updatables = new ArrayList<Updatable>();
    private static volatile boolean updating = false;

    public static void addMod(String modid) {
        CroakLibMod.LOGGER.info("Registered {} to update.", (Object)modid);
        updatables.add(new Updatable(modid, modid));
    }

    public static void addMod(String modid, String modrinthid) {
        CroakLibMod.LOGGER.info("Registered {}/{} to update.", (Object)modid, (Object)modrinthid);
        updatables.add(new Updatable(modid, modrinthid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update() {
        block32: {
            if (updating) {
                return;
            }
            updating = true;
            try {
                UpdateScreen updateScreen = new UpdateScreen();
                class_310.method_1551().method_1507((class_437)updateScreen);
                Path modsDir = Platform.getGameFolder().resolve("mods");
                int currentUpdatable = 0;
                for (Updatable u : updatables) {
                    Path tempFile = Files.createTempFile("mod.update.", ".jar", new FileAttribute[0]);
                    try {
                        URI updateAsset = ModUpdater.getLatestAsset(u);
                        URLConnection connection = updateAsset.toURL().openConnection();
                        connection.connect();
                        long fileSize = connection.getContentLength();
                        try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
                             BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));){
                            int bytesRead;
                            byte[] buffer = new byte[8192];
                            long totalBytesRead = 0L;
                            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                                totalBytesRead += (long)bytesRead;
                                if (fileSize <= 0L) continue;
                                double progress = (double)totalBytesRead / (double)fileSize;
                                updateScreen.setProgress((float)Math.min(progress * 0.9 / (double)updatables.size() * (double)currentUpdatable, 0.9));
                            }
                        }
                        if (!ModUpdater.shouldUpdate(u)) continue;
                        ++currentUpdatable;
                        if (!ModUpdater.isCompatible(tempFile)) continue;
                        Pattern filePattern = Pattern.compile(u.modid + "-" + (Platform.isFabric() ? "fabric" : "forge") + "-.*\\.jar");
                        try (Stream<Path> paths = Files.list(modsDir);){
                            List<Path> mods = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> filePattern.matcher(path.getFileName().toString()).matches()).toList();
                            for (Path mod : mods) {
                                try {
                                    Files.deleteIfExists(mod);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        JsonObject release = ModUpdater.getLatestRelease(u);
                        String version = release.get("version_number").getAsString();
                        Path newModPath = modsDir.resolve(ModUpdater.generateModFilename(u, version));
                        Files.copy(tempFile, newModPath, new CopyOption[0]);
                    }
                    finally {
                        Files.deleteIfExists(tempFile);
                    }
                }
                if (currentUpdatable > 0) {
                    updateScreen.setProgress(1.0f);
                } else {
                    class_310.method_1551().method_1507((class_437)new class_442());
                }
            }
            catch (Exception e) {
                class_310.method_1551().method_1507((class_437)new class_442());
                if (!Platform.isDevelopmentEnvironment()) break block32;
                CroakLibMod.LOGGER.error((Object)e.getStackTrace());
            }
        }
    }

    public static boolean shouldUpdate(Updatable u) throws IOException {
        if (Platform.isDevelopmentEnvironment()) {
            return false;
        }
        return ModUpdater.getCurrentModVersion(u) < ModUpdater.getLatestVersion(u);
    }

    public static URI getLatestAsset(Updatable u) throws IOException {
        JsonObject latest = ModUpdater.getLatestRelease(u);
        JsonArray files = latest.get("files").getAsJsonArray();
        if (files.isEmpty()) {
            throw new IOException("No file found for release?");
        }
        if (files.size() == 1) {
            return URI.create(files.get(0).getAsJsonObject().get("url").getAsString());
        }
        String desiredPlatform = Platform.isFabric() ? "fabric" : "forge";
        for (JsonElement file : files) {
            String filename = file.getAsJsonObject().get("filename").getAsString();
            if (!filename.contains(desiredPlatform)) continue;
            return URI.create(file.getAsJsonObject().get("url").getAsString());
        }
        throw new IOException("No valid file found?");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCompatible(Path jarFile) {
        try (JarFile jar = new JarFile(jarFile.toString());){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            ArrayList supportedVersions = new ArrayList();
            Attributes attrs = manifest.getMainAttributes();
            attrs.forEach((key, value) -> {
                if (key.toString().contains("Minecraft-Version")) {
                    supportedVersions.add(value.toString());
                }
            });
            boolean bl = supportedVersions.contains(Platform.getMinecraftVersion());
            return bl;
        }
        catch (IOException e) {
            CroakLibMod.LOGGER.warn("Failed to read JAR manifest: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static JsonObject getLatestRelease(Updatable u) throws IOException {
        String platformName = Platform.isFabric() ? "fabric" : "forge";
        String platformVers = Platform.getMinecraftVersion();
        String url = "https://api.modrinth.com/v2/project/" + u.modrinthid + "/version?game_versions=[%22" + platformVers + "%22]&loaders=[%22" + platformName + "%22]";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "PrismLauncher/9.1").timeout(Duration.ofSeconds(10L)).GET().build();
        try {
            HttpResponse<String> response = CroakLibMod.HTTP.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("Modrinth API returned status code: " + response.statusCode());
            }
            JsonArray versions = (JsonArray)CroakLibMod.GSON.fromJson(response.body(), JsonArray.class);
            for (JsonElement version : versions) {
                JsonObject data = version.getAsJsonObject();
                if (!data.has("files")) continue;
                return data;
            }
            throw new IOException("No valid version found?");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Request interrupted", e);
        }
    }

    public static String generateModFilename(Updatable u, String version) {
        if (!Platform.isFabric() && !Platform.isForge()) {
            throw new IllegalStateException("Unsupported platform");
        }
        String cleanVersion = version.startsWith("v") ? version.substring(1) : version;
        String platformName = Platform.isFabric() ? "fabric" : "forge";
        return String.format("%s-%s-%s.jar", u.modid, platformName, cleanVersion);
    }

    public static int getCurrentModVersion(Updatable u) {
        return ModUpdater.v(Platform.getMod((String)u.modid).getVersion());
    }

    public static int getLatestVersion(Updatable u) throws IOException {
        JsonObject latest = ModUpdater.getLatestRelease(u);
        return ModUpdater.v(latest.get("version_number").getAsString());
    }

    public static int v(String version) {
        if (version == null || version.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        String cleanVersion = version.startsWith("v") ? version.substring(1) : version;
        String[] parts = cleanVersion.split("\\.");
        if (parts.length != 3) {
            return Integer.MAX_VALUE;
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int patch = Integer.parseInt(parts[2]);
            return major << 16 | minor << 8 | patch;
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static class Updatable {
        private final String modid;
        private final String modrinthid;

        public Updatable(String modid, String modrinthid) {
            this.modid = modid;
            this.modrinthid = modrinthid;
        }
    }
}

