/*
 * Decompiled with CFR 0.152.
 */
package com.croaklib;

import com.croaklib.CroakLibMod;
import com.croaklib.ModUpdater;
import com.croaklib.screen.UpdateScreen;
import dev.architectury.platform.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;

public class ModUpdaterClient {
    private static final int BUFFER_SIZE = 8192;
    private static volatile boolean updating = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update() {
        block22: {
            if (updating) {
                return;
            }
            updating = true;
            try {
                UpdateScreen updateScreen = new UpdateScreen();
                class_310.method_1551().method_1507((class_437)updateScreen);
                int currentUpdatable = 0;
                for (ModUpdater.Updatable u : ModUpdater.updatables) {
                    Path tempFile = Files.createTempFile("mod.update.", ".jar", new FileAttribute[0]);
                    try {
                        URI updateAsset = ModUpdater.getLatestAsset(u);
                        URLConnection connection = updateAsset.toURL().openConnection();
                        connection.connect();
                        long fileSize = connection.getContentLength();
                        try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
                             BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));){
                            int bytesRead;
                            byte[] buffer = new byte[8192];
                            long totalBytesRead = 0L;
                            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                                totalBytesRead += (long)bytesRead;
                                if (fileSize <= 0L) continue;
                                double progress = (double)totalBytesRead / (double)fileSize;
                                updateScreen.setProgress((float)Math.min(progress * 0.9 / (double)ModUpdater.updatables.size() * (double)currentUpdatable, 0.9));
                            }
                        }
                        if (!ModUpdater.shouldUpdate(u)) continue;
                        ++currentUpdatable;
                        ModUpdater.removeDuplicateMods(u, tempFile);
                    }
                    finally {
                        Files.deleteIfExists(tempFile);
                    }
                }
                if (currentUpdatable > 0) {
                    updateScreen.setProgress(1.0f);
                } else {
                    class_310.method_1551().method_1507((class_437)new class_442());
                }
            }
            catch (Exception e) {
                class_310.method_1551().method_1507((class_437)new class_442());
                if (!Platform.isDevelopmentEnvironment()) break block22;
                CroakLibMod.LOGGER.error((Object)e.getStackTrace());
            }
        }
    }
}

