/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.tips;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

@Mod(modid="tippy", version="1.7.0", name="Tippy", acceptableRemoteVersions="1.7.10", acceptedMinecraftVersions="1.7.10", useMetadata=true)
public class Tippy {
    public static Logger logger;
    public static int titleColor;
    public static int contentColor;
    public static int posX;
    public static int posY;
    public static int switchInterval;
    public static List<String> tipKeys;
    public static Random random;
    public static JsonObject configJson;
    public static long lastSwitchTime;
    public static String currentTipKey;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("Initializing Tippy for Minecraft 1.7.10");
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        titleColor = config.getInt("titleColor", "colors", titleColor, 0, 0xFFFFFF, "Title text color (RGB hex)");
        contentColor = config.getInt("contentColor", "colors", contentColor, 0, 0xFFFFFF, "Content text color (RGB hex)");
        posX = config.getInt("posX", "position", posX, 0, 1000, "Horizontal position");
        posY = config.getInt("posY", "position", posY, -1000, 1000, "Vertical position (negative = from bottom)");
        switchInterval = config.getInt("switchInterval", "behavior", switchInterval, 1, 3600, "Tip switch interval in seconds");
        config.save();
        this.loadTipsConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Tippy.updateTipIfNeeded(true);
    }

    private void loadTipsConfig() {
        File configDir = new File("config/tippy");
        File tipsFile = new File(configDir, "tips.json");
        try {
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if (!tipsFile.exists()) {
                JsonObject defaultConfig = new JsonObject();
                JsonArray defaultTips = new JsonArray();
                defaultTips.add((JsonElement)new JsonPrimitive("tippy.tip1"));
                defaultTips.add((JsonElement)new JsonPrimitive("tippy.tip2"));
                defaultTips.add((JsonElement)new JsonPrimitive("tippy.tip3"));
                defaultConfig.add("tips", (JsonElement)defaultTips);
                FileUtils.writeStringToFile((File)tipsFile, (String)new Gson().toJson((JsonElement)defaultConfig), (Charset)StandardCharsets.UTF_8);
            }
            String jsonContent = FileUtils.readFileToString((File)tipsFile, (Charset)StandardCharsets.UTF_8);
            JsonParser parser = new JsonParser();
            configJson = parser.parse(jsonContent).getAsJsonObject();
            tipKeys.clear();
            JsonArray tipsArray = configJson.getAsJsonArray("tips");
            for (int i = 0; i < tipsArray.size(); ++i) {
                tipKeys.add(tipsArray.get(i).getAsString());
            }
            logger.info("Loaded " + tipKeys.size() + " tip keys from config file");
        }
        catch (IOException e) {
            logger.error("Failed to load tips config: " + e.getMessage());
            tipKeys.add("tippy.tip1");
            tipKeys.add("tippy.tip2");
        }
    }

    public static String getCurrentTipKey() {
        return currentTipKey;
    }

    public static void updateTipIfNeeded(boolean forceUpdate) {
        long currentTime = System.currentTimeMillis();
        long intervalMillis = TimeUnit.SECONDS.toMillis(switchInterval);
        if (forceUpdate || currentTime - lastSwitchTime > intervalMillis) {
            currentTipKey = !tipKeys.isEmpty() ? tipKeys.get(random.nextInt(tipKeys.size())) : "tippy.no_tips";
            lastSwitchTime = currentTime;
        }
    }

    static {
        titleColor = 0xFFAA00;
        contentColor = 0xFFFFFF;
        posX = 10;
        posY = -30;
        switchInterval = 10;
        tipKeys = new ArrayList<String>();
        random = new Random();
        lastSwitchTime = 0L;
        currentTipKey = "";
    }
}

