/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.tips;

import cpw.mods.fml.client.FMLClientHandler;
import decok.dfcdvadstf.tips.Tippy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class TipsRenderer {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\\\([nrt\\\\\"'])");

    public static void renderTip(GuiScreen screen) {
        int yPos;
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71466_p == null) {
            return;
        }
        int xPos = Tippy.posX;
        if (xPos < 0) {
            xPos = screen.field_146294_l + xPos;
        }
        if ((yPos = Tippy.posY) < 0) {
            yPos = screen.field_146295_m + yPos;
        }
        String title = StatCollector.func_74838_a((String)"tippy.title");
        String tip = StatCollector.func_74838_a((String)Tippy.getCurrentTipKey());
        tip = TipsRenderer.processEscapeSequences(tip);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71466_p.func_78261_a(title, xPos, yPos, Tippy.titleColor);
        String[] tipLines = tip.split("\n");
        int lineHeight = mc.field_71466_p.field_78288_b + 2;
        for (int i = 0; i < tipLines.length; ++i) {
            mc.field_71466_p.func_78261_a(tipLines[i], xPos, yPos + 10 + i * lineHeight, Tippy.contentColor);
        }
        GL11.glDisable((int)3042);
    }

    private static String processEscapeSequences(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        Matcher matcher = ESCAPE_PATTERN.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String escapeChar;
            switch (escapeChar = matcher.group(1)) {
                case "n": {
                    replacement = "\n";
                    break;
                }
                case "t": {
                    replacement = "\t";
                    break;
                }
                case "r": {
                    replacement = "\r";
                    break;
                }
                case "\\": {
                    replacement = "\\";
                    break;
                }
                case "\"": {
                    replacement = "\"";
                    break;
                }
                case "'": {
                    replacement = "'";
                    break;
                }
                default: {
                    replacement = matcher.group(0);
                }
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

