/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.client.models;

import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.client.models.states.SquealingSpiderRenderState;
import net.sashakyotoz.variousworld.common.entities.anim.SquealingSpiderAnimations;

public class SquealingSpiderModel
extends EntityModel<SquealingSpiderRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(VariousWorld.createVWLocation("squealing_spider_model"), "main");
    private final ModelPart head;
    private final ModelPart teeth;
    private final ModelPart head_crystal;
    private final ModelPart small_body;
    private final ModelPart crystal;
    private final ModelPart belly;
    private final ModelPart rear_leg;
    private final ModelPart rear_leg1;
    private final ModelPart middle_leg;
    private final ModelPart middle_leg1;
    private final ModelPart front_leg;
    private final ModelPart front_leg1;
    private final KeyframeAnimation slide;
    private final KeyframeAnimation slideBack;
    private final KeyframeAnimation longJump;
    private final KeyframeAnimation shoot;
    private final KeyframeAnimation inhale;
    private final KeyframeAnimation walk;

    public SquealingSpiderModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.teeth = this.head.getChild("teeth");
        this.head_crystal = this.head.getChild("head_crystal");
        this.small_body = root.getChild("small_body");
        this.crystal = this.small_body.getChild("crystal");
        this.belly = root.getChild("belly");
        this.rear_leg = root.getChild("rear_leg");
        this.rear_leg1 = root.getChild("rear_leg1");
        this.middle_leg = root.getChild("middle_leg");
        this.middle_leg1 = root.getChild("middle_leg1");
        this.front_leg = root.getChild("front_leg");
        this.front_leg1 = root.getChild("front_leg1");
        this.slide = SquealingSpiderAnimations.JUMP.bake(root);
        this.slideBack = SquealingSpiderAnimations.JUMP.bake(root);
        this.longJump = SquealingSpiderAnimations.JUMP.bake(root);
        this.shoot = SquealingSpiderAnimations.ATTACK.bake(root);
        this.inhale = SquealingSpiderAnimations.ATTACK.bake(root);
        this.walk = SquealingSpiderAnimations.WALK.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)-3.0f));
        PartDefinition teeth = head.addOrReplaceChild("teeth", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 0.0f, 0.24f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-8.25f));
        PartDefinition head_crystal = head.addOrReplaceChild("head_crystal", CubeListBuilder.create().texOffs(49, 5).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-3.0f, (float)-7.0f, (float)0.3491f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r1 = head_crystal.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(49, 5).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition small_body = partdefinition.addOrReplaceChild("small_body", CubeListBuilder.create().texOffs(32, 20).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition crystal = small_body.addOrReplaceChild("crystal", CubeListBuilder.create().texOffs(45, 1).mirror().addBox(-4.5f, -9.0f, 0.0f, 9.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r2 = crystal.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(45, 1).mirror().addBox(-5.0f, -9.0f, 0.0f, 9.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition belly = partdefinition.addOrReplaceChild("belly", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(12, 51).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 0.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(-3.0f, -13.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)9.0f));
        PartDefinition cube_r3 = belly.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(44, 0).addBox(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition rear_leg = partdefinition.addOrReplaceChild("rear_leg", CubeListBuilder.create().texOffs(0, 39).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 50).addBox(-11.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)20.0f, (float)2.0f, (float)0.2618f, (float)0.7854f, (float)0.7854f));
        PartDefinition rear_leg1 = partdefinition.addOrReplaceChild("rear_leg1", CubeListBuilder.create().texOffs(0, 39).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 50).addBox(9.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)2.0f, (float)0.2618f, (float)-0.7854f, (float)-0.7854f));
        PartDefinition middle_leg = partdefinition.addOrReplaceChild("middle_leg", CubeListBuilder.create().texOffs(0, 35).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 50).addBox(-11.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(19, 52).addBox(-13.0f, -1.0f, 0.0f, 2.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition middle_leg1 = partdefinition.addOrReplaceChild("middle_leg1", CubeListBuilder.create().texOffs(0, 35).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 50).addBox(9.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(19, 52).mirror().addBox(11.0f, -1.0f, 0.0f, 2.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition front_leg = partdefinition.addOrReplaceChild("front_leg", CubeListBuilder.create().texOffs(0, 39).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 50).addBox(-11.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)20.0f, (float)-1.0f, (float)-0.2618f, (float)-0.7854f, (float)0.7854f));
        PartDefinition front_leg1 = partdefinition.addOrReplaceChild("front_leg1", CubeListBuilder.create().texOffs(0, 39).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 50).addBox(9.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)20.0f, (float)-1.0f, (float)-0.2618f, (float)0.7854f, (float)-0.7854f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(SquealingSpiderRenderState renderState) {
        super.setupAnim((Object)renderState);
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.walk.applyWalk(renderState.walkAnimationPos, renderState.walkAnimationSpeed, 4.0f, 4.0f);
        this.inhale.apply(renderState.inhale, renderState.ageInTicks, -1.0f);
        this.shoot.apply(renderState.shoot, renderState.ageInTicks, 0.5f);
        this.longJump.apply(renderState.longJump, renderState.ageInTicks, 0.5f);
        this.slideBack.apply(renderState.slideBack, renderState.ageInTicks, -1.0f);
        this.slide.apply(renderState.slide, renderState.ageInTicks, -0.5f);
    }
}

