/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.sashakyotoz.variousworld.init.VWBlocks;

public class BlockUtils {
    public static final BooleanProperty RECLAMITE_SHARDED = BooleanProperty.create((String)"reclamite_sharded");

    public static boolean isReclamited(BlockState state) {
        return BlockUtils.canBeReclamited(state) && (Boolean)state.getValue((Property)RECLAMITE_SHARDED) != false;
    }

    public static boolean canBeReclamited(BlockState state) {
        return state != null && state.hasProperty((Property)RECLAMITE_SHARDED) && state.hasProperty((Property)BlockStateProperties.DRIPSTONE_THICKNESS) && state.getValue((Property)BlockStateProperties.DRIPSTONE_THICKNESS) == DripstoneThickness.TIP;
    }

    public static BlockState getReclamiteEquivalent(BlockState state) {
        if (BlockUtils.canBeReclamited(state)) {
            return state.getValue((Property)BlockStateProperties.VERTICAL_DIRECTION) == Direction.DOWN ? (BlockState)((AmethystClusterBlock)VWBlocks.RECLAIMITE_CRYSTAL.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN) : (BlockState)((AmethystClusterBlock)VWBlocks.RECLAIMITE_CRYSTAL.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP);
        }
        return state;
    }
}

