/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.OnActionsTrigger;
import net.sashakyotoz.variousworld.common.blocks.entities.GemsmithFurnaceBlockEntity;
import net.sashakyotoz.variousworld.common.blocks.entities.gui.GemsmithTableMenu;
import net.sashakyotoz.variousworld.common.blocks.entities.recipes.GemsmithRecipeInput;
import net.sashakyotoz.variousworld.common.blocks.entities.recipes.GemsmithTransformRecipe;
import net.sashakyotoz.variousworld.common.config.ModConfigController;
import net.sashakyotoz.variousworld.common.items.data.CrystalData;
import net.sashakyotoz.variousworld.common.items.data.SupplyCrystalData;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWItems;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;
import org.jetbrains.annotations.Nullable;

public class GemsmithTableBlockEntity
extends BaseContainerBlockEntity {
    public static final BlockCapability<IItemHandler, Void> TABLE_ITEM_HANDLER = BlockCapability.createVoid((ResourceLocation)VariousWorld.createVWLocation("table_item_handler"), IItemHandler.class);
    public final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            GemsmithTableBlockEntity.this.setChanged();
        }
    };
    public NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> GemsmithTableBlockEntity.this.progress;
                case 1 -> GemsmithTableBlockEntity.this.maxProgress;
                case 2 -> GemsmithTableBlockEntity.this.fuel;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    GemsmithTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    GemsmithTableBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    GemsmithTableBlockEntity.this.fuel = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };
    public int progress = 0;
    private int maxProgress = 300;
    private int fuel = 0;

    public GemsmithTableBlockEntity(BlockPos pos, BlockState state) {
        super(VWBlocks.GEMSMITH_TABLE_BE.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.various_world.gemsmith_table");
    }

    protected NonNullList<ItemStack> getItems() {
        if (this.items.isEmpty()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                this.items.set(i, (Object)this.itemHandler.getStackInSlot(i));
            }
        }
        return this.items;
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public ItemStack removeItem(int slot, int amount) {
        this.itemHandler.extractItem(slot, amount, false);
        return super.removeItem(slot, amount);
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)nonNullList.get(i));
        }
        this.items = nonNullList;
    }

    protected void saveAdditional(ValueOutput output) {
        this.itemHandler.serialize(output);
        ContainerHelper.saveAllItems((ValueOutput)output, this.items);
        output.putInt("gemsmith.progress", this.progress);
        output.putInt("gemsmith.max_progress", this.maxProgress);
        super.saveAdditional(output);
    }

    public void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.itemHandler.deserialize(valueInput);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
        valueInput.getInt("gemsmith.progress").ifPresent(value -> {
            this.progress = value;
        });
        valueInput.getInt("gemsmith.max_progress").ifPresent(value -> {
            this.maxProgress = value;
        });
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new GemsmithTableMenu(i, inventory, (BlockEntity)this, this.data);
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return new GemsmithTableMenu(i, inventory, (BlockEntity)this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos pos, BlockState state, GemsmithTableBlockEntity blockEntity) {
        if (!level.isClientSide()) {
            GemsmithFurnaceBlockEntity furnace = this.getFurnace(level, pos);
            if (this.hasRecipe() && furnace != null) {
                blockEntity.fuel = furnace.fuel;
                if (blockEntity.fuel > 0) {
                    ++blockEntity.progress;
                } else if (blockEntity.progress > 0) {
                    --blockEntity.progress;
                }
                GemsmithTableBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    this.craftItem(blockEntity);
                }
            } else {
                blockEntity.resetProgress();
                GemsmithTableBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private void craftItem(GemsmithTableBlockEntity pEntity) {
        Optional<RecipeHolder<GemsmithTransformRecipe>> matchedRecipe = this.getCurrentRecipe();
        if (matchedRecipe.isPresent()) {
            ItemStack result = this.releaseResultStack(matchedRecipe.get(), pEntity);
            pEntity.setItem(2, result);
            for (int i = 0; i < 2; ++i) {
                pEntity.removeItem(i, 1);
            }
            pEntity.resetProgress();
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        this.drops();
        super.preRemoveSideEffects(pos, state);
    }

    private ItemStack releaseResultStack(RecipeHolder<GemsmithTransformRecipe> recipe, GemsmithTableBlockEntity blockEntity) {
        List<ModConfigController.GemsmithingSetting> setting = ModConfigController.CRYSTALING_CONFIG_VALUES;
        if (OnActionsTrigger.isInstanceOfAny(((GemsmithTransformRecipe)recipe.value()).result().getItem()) && setting != null) {
            ItemStack itemstack = ((GemsmithTransformRecipe)recipe.value()).result().copy();
            ItemStack supplyGemStack = new ItemStack((ItemLike)VWItems.SUPPLY_CRYSTAL.get());
            ItemStack gemStack = this.itemHandler.getStackInSlot(1).copy();
            for (ModConfigController.GemsmithingSetting crystalSetting : setting) {
                ResourceKey resourceKey;
                if (gemStack.isEmpty() || !gemStack.is(crystalSetting.item().build())) continue;
                String toolName = OnActionsTrigger.getToolName(itemstack);
                supplyGemStack.set((DataComponentType)VWMiscRegistries.SUPPLY_CRYSTAL_DATA.get(), (Object)new SupplyCrystalData(gemStack, toolName));
                itemstack.set((DataComponentType)VWMiscRegistries.CRYSTAL_DATA.get(), (Object)new CrystalData(supplyGemStack, crystalSetting.durability()));
                ResourceLocation attributeKey = BuiltInRegistries.ATTRIBUTE.getKey((Object)crystalSetting.attribute());
                if (!itemstack.has(DataComponents.ATTRIBUTE_MODIFIERS) || attributeKey == null) {
                    return itemstack;
                }
                List<Object> modifiers = new ArrayList(((ItemAttributeModifiers)itemstack.get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers());
                Registry registry = blockEntity.getLevel().registryAccess().lookupOrThrow(Registries.ATTRIBUTE);
                Optional attributeHolderOpt = registry.get(resourceKey = ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)attributeKey));
                if (attributeHolderOpt.isEmpty()) {
                    return itemstack;
                }
                Holder.Reference attributeHolder = (Holder.Reference)attributeHolderOpt.get();
                if (modifiers.stream().anyMatch(entry -> entry.attribute().is(attributeKey))) {
                    modifiers = modifiers.stream().map(entry -> {
                        if (entry.attribute().is(attributeKey)) {
                            AttributeModifier updatedModifier = new AttributeModifier(entry.modifier().id(), entry.modifier().amount() + crystalSetting.modify_value(), entry.modifier().operation());
                            return new ItemAttributeModifiers.Entry(entry.attribute(), updatedModifier, entry.slot());
                        }
                        return entry;
                    }).collect(Collectors.toList());
                } else {
                    AttributeModifier newModifier = new AttributeModifier(VariousWorld.createVWLocation("tool.modify_attribute" + crystalSetting.prefix()), crystalSetting.modify_value(), AttributeModifier.Operation.ADD_VALUE);
                    modifiers.add(new ItemAttributeModifiers.Entry((Holder)attributeHolder, newModifier, EquipmentSlotGroup.MAINHAND));
                }
                itemstack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers(modifiers));
            }
            return itemstack;
        }
        return this.itemHandler.getStackInSlot(0);
    }

    private GemsmithFurnaceBlockEntity getFurnace(Level level, BlockPos pos) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockEntity blockEntity = level.getBlockEntity(pos.offset(x, 0, z));
                if (!(blockEntity instanceof GemsmithFurnaceBlockEntity)) continue;
                GemsmithFurnaceBlockEntity entity = (GemsmithFurnaceBlockEntity)blockEntity;
                if (level.getBlockEntity(pos.offset(x, 0, z).relative((Direction)level.getBlockState(pos.offset(x, 0, z)).getValue((Property)BlockStateProperties.FACING))) instanceof GemsmithFurnaceBlockEntity) continue;
                return entity;
            }
        }
        return null;
    }

    public boolean hasRecipe() {
        Optional<RecipeHolder<GemsmithTransformRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((GemsmithTransformRecipe)recipe.get().value()).result();
        return this.canInsertAmountIntoOutputSlot(result.getCount()) && this.canInsertItemIntoOutputSlot(result);
    }

    private Optional<RecipeHolder<GemsmithTransformRecipe>> getCurrentRecipe() {
        return ((ServerLevel)this.level).recipeAccess().getRecipeFor((RecipeType)VWMiscRegistries.GEMSMITH_TRANSFORM_TYPE.get(), (RecipeInput)new GemsmithRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1)), this.level);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.itemHandler.getStackInSlot(2).isEmpty() || this.itemHandler.getStackInSlot(2).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(2).getCount() + count <= this.itemHandler.getStackInSlot(2).getMaxStackSize();
    }

    public int getContainerSize() {
        return 3;
    }
}

