/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities.gui;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.sashakyotoz.variousworld.common.blocks.entities.ArtifactTableBlockEntity;
import net.sashakyotoz.variousworld.common.blocks.entities.gui.ITableMenu;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactTableMenu
extends ITableMenu {
    public ArtifactTableBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public ArtifactTableMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, extraData == null ? null : inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(3));
    }

    public ArtifactTableMenu(int id, Inventory inv, @Nullable BlockEntity entity, ContainerData data) {
        super((MenuType)VWMiscRegistries.ARTIFACT_TABLE.get(), id);
        ArtifactTableMenu.checkContainerSize((Container)inv, (int)3);
        this.blockEntity = entity == null ? this.findBlockEntity(inv.player, ArtifactTableBlockEntity.class) : (ArtifactTableBlockEntity)entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        IItemHandler handler = (IItemHandler)this.level.getCapability(ArtifactTableBlockEntity.TABLE_ITEM_HANDLER, this.blockEntity.getBlockPos(), null);
        if (handler != null) {
            this.addSlot((Slot)new SlotItemHandler(handler, 0, 56, 48));
            this.addSlot((Slot)new SlotItemHandler(this, handler, 1, 104, 48){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return stack.getItem() instanceof PotionItem;
                }
            });
            this.addSlot((Slot)new SlotItemHandler(this, handler, 2, 80, 48){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return stack.is(Items.DRAGON_BREATH);
                }
            });
        }
        this.addDataSlots(data);
    }

    public boolean isRefreshing() {
        return this.data.get(0) > 0;
    }

    public boolean isPowered() {
        return (Boolean)this.blockEntity.getLevel().getBlockState(this.blockEntity.getBlockPos()).getValue((Property)BlockStateProperties.TRIGGERED);
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 22;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public boolean stillValid(Player player) {
        return ArtifactTableMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)VWBlocks.ARTIFACT_TABLE.get()));
    }
}

