/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities.gui;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.sashakyotoz.variousworld.common.blocks.entities.DisassemblyTableBlockEntity;
import net.sashakyotoz.variousworld.common.blocks.entities.gui.ITableMenu;
import net.sashakyotoz.variousworld.init.VWBlocks;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisassemblyTableMenu
extends ITableMenu {
    public DisassemblyTableBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public DisassemblyTableMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, extraData == null ? null : inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(3));
    }

    public DisassemblyTableMenu(int id, Inventory inv, @Nullable BlockEntity entity, ContainerData data) {
        super((MenuType)VWMiscRegistries.DISASSEMBLY_TABLE.get(), id);
        DisassemblyTableMenu.checkContainerSize((Container)inv, (int)4);
        this.blockEntity = entity == null ? this.findBlockEntity(inv.player, DisassemblyTableBlockEntity.class) : (DisassemblyTableBlockEntity)entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        IItemHandler handler = (IItemHandler)this.level.getCapability(DisassemblyTableBlockEntity.TABLE_ITEM_HANDLER, this.blockEntity.getBlockPos(), null);
        if (handler != null) {
            this.addSlot((Slot)new SlotItemHandler(handler, 0, 80, 22));
            this.addSlot((Slot)new SlotItemHandler(this, handler, 1, 56, 48){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return false;
                }
            });
            this.addSlot((Slot)new SlotItemHandler(this, handler, 2, 104, 48){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return false;
                }
            });
            this.addSlot((Slot)new SlotItemHandler(handler, 3, 80, 48));
        }
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public float getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 17;
        double ratio = (double)progress / (double)maxProgress;
        int scaled = (int)Math.round(ratio * 17.0);
        return (float)Math.min(scaled, 17) / 20.0f;
    }

    public float getFuelProgress() {
        return Mth.clamp((float)((float)this.data.get(2) / 60.0f), (float)0.0f, (float)1.0f);
    }

    public boolean isFueled() {
        return this.data.get(2) > 0;
    }

    public boolean stillValid(Player player) {
        return DisassemblyTableMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)VWBlocks.DISASSEMBLY_TABLE.get()));
    }
}

