/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.blocks.entities.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.blocks.entities.gui.GemsmithTableMenu;

public class GemsmithTableScreen
extends AbstractContainerScreen<GemsmithTableMenu> {
    private final Level level;
    private final Player player;
    public static final ResourceLocation BACKGROUND_LOCATION = VariousWorld.createVWLocation("textures/gui/gemsmith_table.png");
    private static final ResourceLocation LIT_PROGRESS = ResourceLocation.withDefaultNamespace((String)"container/furnace/lit_progress");
    private static final ResourceLocation BURN_PROGRESS = ResourceLocation.withDefaultNamespace((String)"container/furnace/burn_progress");

    public GemsmithTableScreen(GemsmithTableMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.level = inventory.player.level();
        this.player = inventory.player;
        this.imageWidth = 174;
        this.imageHeight = 164;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.renderIconsProgress(guiGraphics);
    }

    private void renderIconsProgress(GuiGraphics graphics) {
        if (((GemsmithTableMenu)this.getMenu()).isCrafting()) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BURN_PROGRESS, 22, 16, 22 - ((GemsmithTableMenu)this.getMenu()).getScaledProgress(), 0, this.leftPos + 85, this.topPos + 48, ((GemsmithTableMenu)this.getMenu()).getScaledProgress(), 16);
        }
        if (((GemsmithTableMenu)this.getMenu()).getLitProgress() > 0.0f) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, LIT_PROGRESS, 14, Math.round(14.0f * ((GemsmithTableMenu)this.getMenu()).getLitProgress()), 0, 14 - Math.round(14.0f * ((GemsmithTableMenu)this.getMenu()).getLitProgress()), this.leftPos + 90, this.topPos + 66, 14, Math.round(14.0f * ((GemsmithTableMenu)this.getMenu()).getLitProgress()));
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (Minecraft.getInstance().getLanguageManager().getSelected().equals("en_us")) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"block.various_world.gemsmith_table"), 56, 4, MapColor.COLOR_GRAY.col, false);
        }
    }
}

