/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.world.features;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.common.world.features.ModPlacedFeatures;
import net.sashakyotoz.variousworld.init.VWEntities;

public class ModBiomeModifiers {
    public static final ResourceKey<BiomeModifier> SODALITE_GEODE_MODIFIER = ModBiomeModifiers.registerKey("sodalite_geode_modifier");
    public static final ResourceKey<BiomeModifier> WANDERING_ZOMBIE_MODIFIER = ModBiomeModifiers.registerKey("wandering_zombie_modifier");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(SODALITE_GEODE_MODIFIER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_FOREST), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.SODALITE_GEODE)}), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.register(WANDERING_ZOMBIE_MODIFIER, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.STRONGHOLD_BIASED_TO), WeightedList.of((Object)new MobSpawnSettings.SpawnerData((EntityType)VWEntities.WANDERING_ZOMBIE.get(), 1, 2))));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)VariousWorld.createVWLocation(name));
    }
}

