/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.sashakyotoz.variousworld.VariousWorld;
import net.sashakyotoz.variousworld.client.models.CrystalicSlimeModel;
import net.sashakyotoz.variousworld.client.models.states.CrystalicSlimeRenderState;
import net.sashakyotoz.variousworld.client.renderers.layers.CrystalicSlimeOuterLayer;
import net.sashakyotoz.variousworld.common.entities.CrystalicSlimeEntity;

public class CrystalicSlimeRenderer
extends MobRenderer<CrystalicSlimeEntity, CrystalicSlimeRenderState, CrystalicSlimeModel> {
    public static final ResourceLocation SLIME_LOCATION = VariousWorld.createVWLocation("textures/entity/crystalic_slime0.png");
    private static final ResourceLocation SLIME_LOCATION1 = VariousWorld.createVWLocation("textures/entity/crystalic_slime1.png");
    private static final ResourceLocation SLIME_LOCATION2 = VariousWorld.createVWLocation("textures/entity/crystalic_slime2.png");

    public CrystalicSlimeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CrystalicSlimeModel(context.bakeLayer(CrystalicSlimeModel.LAYER_LOCATION)), 0.9f);
        this.addLayer(new CrystalicSlimeOuterLayer((RenderLayerParent<CrystalicSlimeRenderState, CrystalicSlimeModel>)this, context.getModelSet()));
    }

    public CrystalicSlimeRenderState createRenderState() {
        return new CrystalicSlimeRenderState();
    }

    public void extractRenderState(CrystalicSlimeEntity entity, CrystalicSlimeRenderState state, float squish) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, squish);
        state.squish = Mth.lerp((float)squish, (float)entity.oSquish, (float)entity.squish);
        state.size = entity.getSize();
        state.textureVariant = entity.getTextureInt();
        state.scale = entity.getScale();
    }

    protected void scale(CrystalicSlimeRenderState state, PoseStack stack) {
        stack.scale(0.999f, 0.999f, 0.999f);
        stack.translate(0.0f, 0.001f, 0.0f);
        float f1 = state.size;
        float f2 = state.squish / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        stack.scale(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public ResourceLocation getTextureLocation(CrystalicSlimeRenderState slimeRenderState) {
        return switch (slimeRenderState.textureVariant) {
            case 1 -> SLIME_LOCATION1;
            case 2 -> SLIME_LOCATION2;
            default -> SLIME_LOCATION;
        };
    }
}

