/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.fml.loading.FMLPaths;
import net.sashakyotoz.variousworld.VariousWorld;

public class ModConfigController {
    public static Configs MOD_CONFIG_VALUES;
    public static List<GemsmithingSetting> CRYSTALING_CONFIG_VALUES;
    public static List<ArtifactSetting> ARTIFACTS_CONFIG_VALUES;
    private static final Gson gson;

    public static void init() {
        try {
            Path configPath = FMLPaths.CONFIGDIR.get().resolve("various_world-config.json");
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.writeString(configPath, (CharSequence)ModConfigController.getDefaultConfigJson(), new OpenOption[0]);
            }
            String json = Files.readString(configPath);
            ConfigData data = (ConfigData)gson.fromJson(json, ConfigData.class);
            MOD_CONFIG_VALUES = data.configs;
            CRYSTALING_CONFIG_VALUES = data.crystalingSettings;
            ARTIFACTS_CONFIG_VALUES = data.artifactsSettings;
        }
        catch (Exception e) {
            VariousWorld.log("Various World config can't be read");
        }
    }

    private static String getDefaultConfigJson() {
        return "{\n    \"configs\": {\n      \"do_crystalline_forest\": true,\n      \"do_blue_jacaranda_meadow\": true,\n      \"do_reclamite_caves\": true\n    },\n    \"crystaling_settings\": [\n      {\n        \"item\": \"various_world:sodalite_shard\",\n        \"prefix\": \"sodalite\",\n        \"durability\": 128,\n        \"attribute\": \"block_break_speed\",\n        \"modify_value\": 0.2\n      },\n      {\n        \"item\": \"various_world:crystalline_slime_ball\",\n        \"prefix\": \"crystalline_slime_ball\",\n        \"durability\": 32,\n        \"attribute\": \"attack_knockback\",\n        \"modify_value\": 0.1\n      },\n      {\n        \"item\": \"minecraft:amethyst_shard\",\n        \"prefix\": \"amethyst\",\n        \"durability\": 72,\n        \"attribute\": \"attack_damage\",\n        \"modify_value\": 1\n      }\n    ],\n    \"artifacts_settings\": [\n      {\n        \"artifact\": \"various_world:crystalline_strength\",\n        \"effect_strength\": 2,\n        \"effect_range\": 8\n      },\n      {\n        \"artifact\": \"minecraft:totem_of_undying\",\n        \"effect_strength\": 3,\n        \"effect_range\": 6\n      },\n      {\n        \"artifact\": \"minecraft:ominous_trial_key\",\n        \"effect_strength\": 1,\n        \"effect_range\": 9\n      },\n      {\n        \"artifact\": \"phantasm:shattered_pendant\",\n        \"effect_strength\": 2,\n        \"effect_range\": 12\n      },\n      {\n        \"artifact\": \"nullnite_echo:nullnited_pendant\",\n        \"effect_strength\": 3,\n        \"effect_range\": 16\n      }\n    ]\n  }\n";
    }

    static {
        gson = new GsonBuilder().registerTypeAdapter(LazyItem.class, (Object)new LazyItemDeserializer()).registerTypeAdapter(Attribute.class, (Object)new AttributeDeserializer()).setPrettyPrinting().create();
    }

    public static class ConfigData {
        public Configs configs;
        @SerializedName(value="crystaling_settings")
        public List<GemsmithingSetting> crystalingSettings;
        @SerializedName(value="artifacts_settings")
        public List<ArtifactSetting> artifactsSettings;
    }

    public record Configs(boolean do_crystalline_forest, boolean do_blue_jacaranda_meadow, boolean do_reclamite_caves) {
    }

    public static class LazyItem {
        private final ResourceLocation itemId;

        public LazyItem(String id) {
            this.itemId = ResourceLocation.parse((String)id);
        }

        public Item build() {
            if (BuiltInRegistries.ITEM.get(this.itemId).isPresent()) {
                return (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(this.itemId).get()).value();
            }
            return Items.AIR;
        }

        public ResourceLocation getId() {
            return this.itemId;
        }
    }

    public static class LazyItemDeserializer
    implements JsonDeserializer<LazyItem> {
        public LazyItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String itemId = json.getAsString();
            return new LazyItem(itemId);
        }
    }

    public static class AttributeDeserializer
    implements JsonDeserializer<Attribute> {
        public Attribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String attributeId = json.getAsString();
            if (BuiltInRegistries.ATTRIBUTE.get(ResourceLocation.parse((String)attributeId)).isPresent()) {
                return (Attribute)((Holder.Reference)BuiltInRegistries.ATTRIBUTE.get(ResourceLocation.parse((String)attributeId)).get()).value();
            }
            return (Attribute)Attributes.ENTITY_INTERACTION_RANGE.value();
        }
    }

    public record ArtifactSetting(LazyItem artifact, int effect_strength, int effect_range) {
    }

    public record GemsmithingSetting(LazyItem item, String prefix, int durability, Attribute attribute, double modify_value) {
    }
}

