/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.config.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.sashakyotoz.variousworld.common.items.data.GeodeCompassData;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;

public class GeodeCompassAngleState
extends NeedleDirectionHelper {
    public static final MapCodec<GeodeCompassAngleState> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(NeedleDirectionHelper::wobble), (App)CompassTarget.CODEC.fieldOf("target").forGetter(GeodeCompassAngleState::target)).apply((Applicative)instance, GeodeCompassAngleState::new));
    private final NeedleDirectionHelper.Wobbler wobbler = this.newWobbler(0.8f);
    private final NeedleDirectionHelper.Wobbler noTargetWobbler = this.newWobbler(0.8f);
    private final CompassTarget compassTarget;
    private final RandomSource random = RandomSource.create();

    public GeodeCompassAngleState(boolean wobble, CompassTarget compassTarget) {
        super(wobble);
        this.compassTarget = compassTarget;
    }

    protected float calculate(ItemStack stack, ClientLevel level, int seed, @Nullable ItemOwner owner) {
        GlobalPos globalpos = this.compassTarget.get(level, stack, owner);
        long i = level.getGameTime();
        return !GeodeCompassAngleState.isValidCompassTargetPos(owner, globalpos) ? this.getRandomlySpinningRotation(seed, i) : this.getRotationTowardsCompassTarget(owner, i, globalpos.pos());
    }

    private float getRandomlySpinningRotation(int seed, long gameTime) {
        if (this.noTargetWobbler.shouldUpdate(gameTime)) {
            this.noTargetWobbler.update(gameTime, this.random.nextFloat());
        }
        float f = this.noTargetWobbler.rotation() + (float)GeodeCompassAngleState.hash(seed) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(ItemOwner owner, long gameTime, BlockPos pos) {
        Player player;
        float f = (float)GeodeCompassAngleState.getAngleFromEntityToPos(owner, pos);
        float f1 = GeodeCompassAngleState.getWrappedVisualRotationY(owner);
        LivingEntity var9 = owner.asLivingEntity();
        if (var9 instanceof Player && (player = (Player)var9).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(gameTime)) {
                this.wobbler.update(gameTime, 0.5f - (f1 - 0.25f));
            }
            float f2 = f + this.wobbler.rotation();
            return Mth.positiveModulo((float)f2, (float)1.0f);
        }
        float f2 = 0.5f - (f1 - 0.25f - f);
        return Mth.positiveModulo((float)f2, (float)1.0f);
    }

    private static boolean isValidCompassTargetPos(@Nullable ItemOwner owner, @Nullable GlobalPos pos) {
        return pos != null && owner != null && pos.dimension() == owner.level().dimension() && !(pos.pos().distToCenterSqr((Position)owner.position()) < (double)1.0E-5f);
    }

    private static double getAngleFromEntityToPos(ItemOwner owner, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        Vec3 vec31 = owner.position();
        return Math.atan2(vec3.z() - vec31.z(), vec3.x() - vec31.x()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(ItemOwner owner) {
        return Mth.positiveModulo((float)(owner.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int seed) {
        return seed * 1327217883;
    }

    protected CompassTarget target() {
        return this.compassTarget;
    }

    public static enum CompassTarget implements StringRepresentable
    {
        NONE("none"){

            @Override
            @Nullable
            public GlobalPos get(ClientLevel level, ItemStack stack, @Nullable ItemOwner owner) {
                return null;
            }
        }
        ,
        GEODE("geode"){

            @Override
            @Nullable
            public GlobalPos get(ClientLevel level, ItemStack stack, @Nullable ItemOwner owner) {
                if (stack.has((DataComponentType)VWMiscRegistries.GEODE_COMPASS_DATA.get())) {
                    return ((GeodeCompassData)stack.get((DataComponentType)VWMiscRegistries.GEODE_COMPASS_DATA.get())).globalPos();
                }
                return new GlobalPos(Level.OVERWORLD, new BlockPos(0, 0, 0));
            }
        };

        public static final Codec<CompassTarget> CODEC;
        private final String name;

        private CompassTarget(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        @Nullable
        abstract GlobalPos get(ClientLevel var1, ItemStack var2, @Nullable ItemOwner var3);

        static {
            CODEC = StringRepresentable.fromEnum(CompassTarget::values);
        }
    }
}

