/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.items.custom;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.sashakyotoz.variousworld.common.items.data.GeodeCompassData;
import net.sashakyotoz.variousworld.init.VWMiscRegistries;
import org.jetbrains.annotations.Nullable;

public class GeodeCompassItem
extends Item {
    public GeodeCompassItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            if (itemStack.has((DataComponentType)VWMiscRegistries.GEODE_COMPASS_DATA.get())) {
                BlockPos pos = GeodeCompassItem.findNearestAmethystCluster(player, serverLevel, 512);
                if (pos == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.various_world.geode_not_found"), true);
                } else {
                    itemStack.set((DataComponentType)VWMiscRegistries.GEODE_COMPASS_DATA.get(), (Object)new GeodeCompassData(new GlobalPos(serverLevel.getLevel().dimension(), pos)));
                }
            }
        }
        player.getCooldowns().addCooldown(itemStack, 100);
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        Block block;
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        if (stack.has((DataComponentType)VWMiscRegistries.GEODE_COMPASS_DATA.get()) && context.level() != null && !tooltipDisplay.hideTooltip() && (block = context.level().getBlockState(((GeodeCompassData)stack.get((DataComponentType)VWMiscRegistries.GEODE_COMPASS_DATA.get())).globalPos().pos()).getBlock()) instanceof AmethystClusterBlock) {
            AmethystClusterBlock block2 = (AmethystClusterBlock)block;
            tooltipAdder.accept((Component)block2.getName());
        }
    }

    @Nullable
    public static BlockPos findNearestAmethystCluster(Player player, ServerLevel level, int maxChunkRadius) {
        BlockPos origin = player.blockPosition();
        int originChunkX = origin.getX() >> 4;
        int originChunkZ = origin.getZ() >> 4;
        int worldMinY = level.getMinY();
        int worldMaxY = level.getMaxY() - 1;
        int scanMinY = Math.max(worldMinY, -58);
        int scanMaxY = Math.min(worldMaxY, 30);
        BlockPos bestPos = null;
        long bestDistSq = Long.MAX_VALUE;
        for (int r = 0; r <= maxChunkRadius; ++r) {
            if (r == 0) {
                if ((bestPos = GeodeCompassItem.scanChunkForAmethyst(level, originChunkX, originChunkZ, scanMinY, scanMaxY, origin, bestPos, bestDistSq)) == null || (bestDistSq = GeodeCompassItem.squaredDistance(origin, bestPos)) != 0L) continue;
                return bestPos;
            }
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    int cz;
                    int cx;
                    ChunkAccess chunk;
                    if (Math.abs(dx) != r && Math.abs(dz) != r || (chunk = level.getChunk(cx = originChunkX + dx, cz = originChunkZ + dz, ChunkStatus.FULL, false)) == null) continue;
                    int baseX = cx << 4;
                    int baseZ = cz << 4;
                    for (int y = scanMinY; y <= scanMaxY; ++y) {
                        for (int lx = 0; lx < 16; ++lx) {
                            for (int lz = 0; lz < 16; ++lz) {
                                long distSq;
                                BlockPos pos = new BlockPos(baseX + lx, y, baseZ + lz);
                                BlockState bs = chunk.getBlockState(pos);
                                if (!(bs.getBlock() instanceof AmethystClusterBlock) || (distSq = GeodeCompassItem.squaredDistance(origin, pos)) >= bestDistSq) continue;
                                bestDistSq = distSq;
                                bestPos = pos;
                                if (bestDistSq != 0L) continue;
                                return bestPos;
                            }
                        }
                    }
                }
            }
        }
        return bestPos;
    }

    private static BlockPos scanChunkForAmethyst(ServerLevel level, int chunkX, int chunkZ, int minY, int maxY, BlockPos origin, BlockPos currentBestPos, long currentBestDistSq) {
        ChunkAccess chunk = level.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
        if (chunk == null) {
            return currentBestPos;
        }
        int baseX = chunkX << 4;
        int baseZ = chunkZ << 4;
        BlockPos bestPos = currentBestPos;
        long bestDistSq = currentBestDistSq;
        for (int y = minY; y <= maxY; ++y) {
            for (int lx = 0; lx < 16; ++lx) {
                for (int lz = 0; lz < 16; ++lz) {
                    long distSq;
                    BlockPos pos = new BlockPos(baseX + lx, y, baseZ + lz);
                    BlockState bs = chunk.getBlockState(pos);
                    if (!(bs.getBlock() instanceof AmethystClusterBlock) || (distSq = GeodeCompassItem.squaredDistance(origin, pos)) >= bestDistSq) continue;
                    bestDistSq = distSq;
                    bestPos = pos;
                    if (bestDistSq != 0L) continue;
                    return bestPos;
                }
            }
        }
        return bestPos;
    }

    private static long squaredDistance(BlockPos a, BlockPos b) {
        long dx = (long)a.getX() - (long)b.getX();
        long dy = (long)a.getY() - (long)b.getY();
        long dz = (long)a.getZ() - (long)b.getZ();
        return dx * dx + dy * dy + dz * dz;
    }
}

