/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.variousworld.common.world.features.trees;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.sashakyotoz.variousworld.init.VWFeatures;

public class FancyHangingFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<FancyHangingFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(placer -> FancyHangingFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)placer).and(placer.group((App)IntProvider.codec((int)3, (int)16).fieldOf("height").forGetter(height -> height.height), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("flower_decoration_chance").forGetter(flowerChance -> Float.valueOf(flowerChance.flowerDecorationChance)))).apply((Applicative)placer, FancyHangingFoliagePlacer::new));
    private final IntProvider height;
    private final float flowerDecorationChance;

    public FancyHangingFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider height, float flowerDecorationChance) {
        super(radius, offset);
        this.height = height;
        this.flowerDecorationChance = flowerDecorationChance;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)VWFeatures.FANCY_HANGING_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfig, int i, FoliagePlacer.FoliageAttachment foliage, int j, int k, int height) {
        BlockPos blockpos = foliage.pos().above(height - 1);
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos);
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().north());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().south());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.east().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.west().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().north().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().west().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().south().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().west().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().north().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.north().east().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().south().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.south().east().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().north());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().south());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().east().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().west().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().west());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().west());
        if (random.nextInt(3) == 0) {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().south().west());
        }
        if (random.nextInt(3) == 0) {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().west().west());
        }
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().east());
        if (random.nextInt(3) == 0) {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().north().east());
        }
        if (random.nextInt(3) == 0) {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().north().east().east());
        }
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().east());
        if (random.nextInt(3) == 0) {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().south().east());
        }
        if (random.nextInt(3) == 0) {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().south().east().east());
        }
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above().north());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above().south());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above().east());
        FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfig, blockpos.above().above().west());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().north());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().south());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.east().east());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.west().west());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().north().west());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().west().west());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().south().west());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().west().west());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().north().east());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.north().east().east());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().south().east());
        FancyHangingFoliagePlacer.placeHangingLeaves(level, setter, random, treeConfig, blockpos.south().east().east());
    }

    public int foliageHeight(RandomSource random, int i, TreeConfiguration treeConfiguration) {
        return this.height.sample(random);
    }

    protected boolean shouldSkipLocation(RandomSource randomSource, int i, int j, int k, int l, boolean b) {
        return false;
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = treeConfiguration.foliageProvider.getState(random, pos);
        if (blockstate.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            blockstate = (BlockState)blockstate.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(pos, state -> state.isSourceOfType((Fluid)Fluids.WATER))));
        }
        setter.set(pos, blockstate);
        return true;
    }

    protected static void placeHangingLeaves(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        int type = random.nextInt(3);
        if (type == 0) {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
        } else if (type == 1) {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.below());
        } else {
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.below());
            FancyHangingFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.below().below());
        }
    }
}

