/*
 * Decompiled with CFR 0.152.
 */
package fr.formiko.potioneffectsremover;

import fr.formiko.potioneffectsremover.PotionEffectsRemoverCommand;
import fr.formiko.potioneffectsremover.PotionEffectsRemoverListener;
import fr.formiko.potioneffectsremover.lib.co.aikar.commands.PaperCommandManager;
import fr.formiko.potioneffectsremover.lib.org.bstats.bukkit.Metrics;
import java.util.Collection;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectsRemoverPlugin
extends JavaPlugin {
    private Collection<PotionEffectType> disabledPotionEffects;
    private Collection<GameMode> bypassGameModes;
    private Collection<EntityPotionEffectEvent.Cause> bypassCauses;

    public static PotionEffectsRemoverPlugin getInstance() {
        return (PotionEffectsRemoverPlugin)JavaPlugin.getPlugin(PotionEffectsRemoverPlugin.class);
    }

    public void onEnable() {
        new Metrics((Plugin)this, 21741);
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new PotionEffectsRemoverListener(), (Plugin)this);
        PaperCommandManager manager = new PaperCommandManager((Plugin)this);
        manager.registerCommand(new PotionEffectsRemoverCommand());
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.disabledPotionEffects = this.getConfig().getStringList("disabledPotionEffects").stream().map(dpe -> (PotionEffectType)Registry.POTION_EFFECT_TYPE.get(NamespacedKey.minecraft((String)dpe.toLowerCase()))).toList();
        this.bypassGameModes = this.getConfig().getStringList("bypassGameModes").stream().map(GameMode::valueOf).toList();
        this.bypassCauses = this.getConfig().getStringList("bypassCauses").stream().map(EntityPotionEffectEvent.Cause::valueOf).toList();
    }

    public Collection<PotionEffectType> getDisabledPotionEffects() {
        return this.disabledPotionEffects;
    }

    public Collection<GameMode> getBypassGameModes() {
        return this.bypassGameModes;
    }

    public Collection<EntityPotionEffectEvent.Cause> getBypassCauses() {
        return this.bypassCauses;
    }

    public static void log(String message) {
        if (PotionEffectsRemoverPlugin.getInstance().getConfig().getBoolean("debug", false)) {
            PotionEffectsRemoverPlugin.getInstance().getLogger().info(message);
        }
    }
}

