/*
 * Decompiled with CFR 0.152.
 */
package fr.formiko.potioneffectsremover;

import fr.formiko.potioneffectsremover.PotionEffectsRemoverPlugin;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class PotionEffectsRemoverListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPotionEffectEvent(EntityPotionEffectEvent event) {
        if (this.isPotionEffectAddedOrChanged(event.getAction()) && this.isARemovedPotionEffectType(event) && this.isAValideEntity(event.getEntity()) && this.isAValideCause(event.getCause())) {
            event.setCancelled(true);
        }
        PotionEffectsRemoverPlugin.log(event.getEntity().getName() + " had a potion effect removed ? " + event.getModifiedType().translationKey() + " " + this.isPotionEffectAddedOrChanged(event.getAction()) + " " + this.isARemovedPotionEffectType(event) + " " + this.isAValideEntity(event.getEntity()) + " " + this.isAValideCause(event.getCause()) + " => " + event.isCancelled());
    }

    private boolean isPotionEffectAddedOrChanged(EntityPotionEffectEvent.Action action) {
        return action == EntityPotionEffectEvent.Action.ADDED || action == EntityPotionEffectEvent.Action.CHANGED;
    }

    private boolean isAValideEntity(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !PotionEffectsRemoverPlugin.getInstance().getBypassGameModes().contains(player.getGameMode());
        }
        return !PotionEffectsRemoverPlugin.getInstance().getConfig().getBoolean("affectOnlyPlayers", false);
    }

    private boolean isAValideCause(EntityPotionEffectEvent.Cause cause) {
        return !PotionEffectsRemoverPlugin.getInstance().getBypassCauses().contains(cause);
    }

    private boolean isARemovedPotionEffectType(EntityPotionEffectEvent event) {
        return PotionEffectsRemoverPlugin.getInstance().getDisabledPotionEffects().contains(event.getModifiedType());
    }
}

