/*
 * Decompiled with CFR 0.152.
 */
package it.icewolf23x.betterCustomArmors.events;

import it.icewolf23x.betterCustomArmors.BetterCustomArmors;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;

public class CustomArmorCraftListener
implements Listener {
    public CustomArmorCraftListener(BetterCustomArmors plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public static void craft(PrepareItemCraftEvent e) {
        Keyed keyedRecipe;
        NamespacedKey key;
        CraftingInventory inv = e.getInventory();
        Recipe recipe = e.getRecipe();
        if (recipe instanceof Keyed && (key = (keyedRecipe = (Keyed)recipe).getKey()).getKey().contains("better_custom_armors_recipe_")) {
            ItemStack newItem = recipe.getResult();
            ItemStack oldItem = inv.getMatrix()[4];
            assert (oldItem != null);
            inv.setResult(CustomArmorCraftListener.convertItem(oldItem, newItem));
        }
    }

    private static ItemStack convertItem(ItemStack oldItem, ItemStack newItem) {
        Damageable oldMeta;
        int armorValue;
        String armorName;
        ItemStack resultItem = newItem.clone();
        int armorToughnessValue = 3;
        float knockbackResisenceValue = 0.1f;
        int durability = switch (oldItem.getType()) {
            case Material.NETHERITE_HELMET -> {
                armorName = "Dyed Netherite Helmet";
                armorValue = 3;
                yield 407;
            }
            case Material.NETHERITE_CHESTPLATE -> {
                armorName = "Dyed Netherite Chestplate";
                armorValue = 8;
                yield 592;
            }
            case Material.NETHERITE_LEGGINGS -> {
                armorName = "Dyed Netherite Leggings";
                armorValue = 6;
                yield 555;
            }
            case Material.NETHERITE_BOOTS -> {
                armorName = "Dyed Netherite Boots";
                armorValue = 3;
                yield 481;
            }
            default -> {
                armorName = "Dyed Netherite Armor";
                armorValue = 0;
                yield 0;
            }
        };
        ItemMeta itemMeta = newItem.getItemMeta();
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta newMeta = (LeatherArmorMeta)itemMeta;
            oldMeta = (Damageable)oldItem.getItemMeta();
            newMeta.customName(oldMeta.customName());
            for (Enchantment enchant : oldMeta.getEnchants().keySet()) {
                newMeta.addEnchant(enchant, ((Integer)oldMeta.getEnchants().get(enchant)).intValue(), false);
            }
            newMeta.customName(((TextComponent)Component.text((String)armorName).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
            AttributeModifier armorModifier = new AttributeModifier(UUID.randomUUID(), "generic.armor", (double)armorValue, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ARMOR);
            AttributeModifier armorToughnessModifier = new AttributeModifier(UUID.randomUUID(), "generic.armorToughness", (double)armorToughnessValue, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ARMOR);
            AttributeModifier knockbackResistanceModifier = new AttributeModifier(UUID.randomUUID(), "generic.knockbackResistance", (double)knockbackResisenceValue, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ARMOR);
            newMeta.addAttributeModifier(Attribute.ARMOR, armorModifier);
            newMeta.addAttributeModifier(Attribute.ARMOR_TOUGHNESS, armorToughnessModifier);
            newMeta.addAttributeModifier(Attribute.KNOCKBACK_RESISTANCE, knockbackResistanceModifier);
            Damageable resultMeta = (Damageable)newMeta;
            resultMeta.setMaxDamage(Integer.valueOf(durability));
            resultItem.setItemMeta((ItemMeta)resultMeta);
            return resultItem;
        }
        oldMeta = (Damageable)oldItem.getItemMeta();
        Damageable newMeta = oldMeta.clone();
        newMeta.customName(((TextComponent)Component.text((String)armorName).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
        newMeta.setMaxDamage(Integer.valueOf(durability));
        AttributeModifier armorModifier = new AttributeModifier(UUID.randomUUID(), "generic.armor", (double)armorValue, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ARMOR);
        AttributeModifier armorToughnessModifier = new AttributeModifier(UUID.randomUUID(), "generic.armorToughness", (double)armorToughnessValue, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ARMOR);
        AttributeModifier knockbackResistanceModifier = new AttributeModifier(UUID.randomUUID(), "generic.knockbackResistance", (double)knockbackResisenceValue, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ARMOR);
        newMeta.addAttributeModifier(Attribute.ARMOR, armorModifier);
        newMeta.addAttributeModifier(Attribute.ARMOR_TOUGHNESS, armorToughnessModifier);
        newMeta.addAttributeModifier(Attribute.KNOCKBACK_RESISTANCE, knockbackResistanceModifier);
        resultItem.setItemMeta((ItemMeta)newMeta);
        return resultItem;
    }
}

