{
	onDamage(damage, target, source, effect) {
		if (
			effect && effect.effectType === 'Move' &&
			!target.fainted && !target.volatiles['emergencyexit'] &&
			target.hp - damage <= target.maxhp / 2 && target.hp > target.maxhp / 2
		) {
			target.addVolatile('emergencyexit');
		}
	},
	condition: {
		onResidualOrder: 99,
		onResidual(pokemon) {
			if (!this.canSwitch(pokemon.side)) return;
			if (pokemon.forceSwitchFlag || pokemon.switchFlag) return;

			for (const side of this.sides) {
				for (const active of side.active) {
					active.switchFlag = false;
				}
			}
			pokemon.switchFlag = true;
			this.add('-activate', pokemon, 'ability: Emergency Exit');
			pokemon.removeVolatile('emergencyexit');
		},
	},
	flags: {},
	name: "Emergency Exit",
	rating: 1,
	num: 194,
}