{
	onStart(pokemon) {
		const item = pokemon.getItem().id;
		switch (item) {
			case 'heatrock':
				this.field.setWeather('sunnyday');
				break;
			case 'damprock':
				this.field.setWeather('raindance');
				break;
			case 'icyrock':
				this.field.setWeather('snow');
				break;
			case 'smoothrock':
				this.field.setWeather('sandstorm');
				break;
		}

		this.singleEvent('WeatherChange', this.effect, this.effectState, pokemon);
	},

	onWeatherChange(pokemon) {
		if (pokemon.baseSpecies.baseSpecies !== 'Castform' || pokemon.transformed) return;

		let forme = null;
		switch (pokemon.effectiveWeather()) {
			case 'sunnyday':
			case 'desolateland':
				if (pokemon.species.id !== 'castformsunny') forme = 'Castform-Sunny';
				break;
			case 'raindance':
			case 'primordialsea':
				if (pokemon.species.id !== 'castformrainy') forme = 'Castform-Rainy';
				break;
			case 'hail':
			case 'snow':
				if (pokemon.species.id !== 'castformsnowy') forme = 'Castform-Snowy';
				break;
			default:
				if (pokemon.species.id !== 'castform') forme = 'Castform';
				break;
		}
		if (pokemon.isActive && forme) {
			pokemon.formeChange(forme, this.effect, false, '[msg]');
		}
	},

	flags: { failroleplay: 1, noreceiver: 1, noentrain: 1, notrace: 1 },
	name: "Forecast",
	rating: 2,
	num: 59,
}