{
  onStart(pokemon) {
    if (!pokemon.m.pheonixUsed) pokemon.m.pheonixUsed = false;
  },
  onDamage(damage, target, source, effect) {
    if (
      damage >= target.hp &&
      !target.m.pheonixUsed &&
      target.hp > 0
    ) {
      this.add('-ability', target, 'Phoenix Down');
      this.add('-message', `${target.name} held on thanks to Phoenix Down!`);

      target.m.pheonixUsed = true;

      target.sethp(Math.floor(target.maxhp / 2));
      this.add('-heal', target, target.getHealth, '[from] ability: Phoenix Down');

      target.cureStatus();
      target.clearBoosts();
      this.add('-clearboost', target, '[silent]');

      for (const moveSlot of target.moveSlots) {
        moveSlot.pp = Math.min(5, this.dex.moves.get(moveSlot.id).pp);
      }

      return 0; 
    }
  },
  onBeforeHit(target, source, move) {
    if (
      target.m.pheonixUsed &&
      move &&
      move.secondaries?.length
    ) {
      this.add('-message', `Phoenix Down blocked secondary effects!`);
      move.secondaries = [];
    }
  },
  name: "Phoenix Down",
  rating: 5,
  num: -1006,
}
