{
	onModifySecondaries(secondaries) {
		this.debug('Shield Dust prevents secondary effects');
		return secondaries.filter(effect => !!(effect.self || effect.dustproof));
	},
	onSwitchIn(pokemon) {
		const side = pokemon.side;

		if (side.sideConditions['stealthrock']) {
			this.add('-ability', pokemon, 'Shield Dust');
			this.add('-message', `${pokemon.name} is protected from Stealth Rock by Shield Dust!`);
		}

		if (side.sideConditions['spikes']) {
			this.add('-ability', pokemon, 'Shield Dust');
			this.add('-message', `${pokemon.name} is protected from Spikes by Shield Dust!`);
		}

		if (side.sideConditions['toxicspikes']) {
			this.add('-ability', pokemon, 'Shield Dust');
			this.add('-message', `${pokemon.name} is protected from Toxic Spikes by Shield Dust!`);
		}

		if (side.sideConditions['stickyweb']) {
			this.add('-ability', pokemon, 'Shield Dust');
			this.add('-message', `${pokemon.name} is protected from Sticky Web by Shield Dust!`);
		}

		pokemon.shieldDustImmuneToHazards = true;
	},

	onTryHit(pokemon, target, move) {
		if (pokemon.shieldDustImmuneToHazards && move && move.isHazard) {
			this.debug(`${move.name} prevented by Shield Dust`);
			return null;
		}
	},

	flags: { breakable: 1 },
	name: "Shield Dust",
	rating: 2,
	num: 19,
}