{
  onStart(pokemon) {
    this.add('-ability', pokemon, 'Surprise!');
    this.add('-message', `${pokemon.name} triggered a surprise effect!`);
    const rand = this.random(5);
    this.add('-message', `Random roll: ${rand}`);
    switch (rand) {
      case 0:
        this.add('-message', `Surprise: +1 Attack`);
        this.boost({ atk: 1 }, pokemon);
        break;
      case 1:
        this.add('-message', `Surprise: +1 Speed`);
        this.boost({ spe: 1 }, pokemon);
        break;
      case 2:
        this.add('-message', `Surprise: Intimidate`);
        for (const target of pokemon.adjacentFoes()) {
          if (!target.volatiles['substitute']) {
            this.boost({ atk: -1 }, target, pokemon, null, true);
          }
        }
        break;
      case 3:
        this.add('-message', `Surprise: Slow Start`);
        pokemon.addVolatile({
          id: 'surprise-slowstart',
          duration: 5,
          onModifyAtk(atk) {
            return this.chainModify(0.5);
          },
          onModifySpe(spe) {
            return this.chainModify(0.5);
          },
          onEnd(pokemon) {
            this.add('-end', pokemon, 'Surprise! (Slow Start)');
          },
        });
        break;
      case 4:
        this.add('-message', `Surprise: Snow Warning`);
        this.field.setWeather('snow');
        break;
    }
  },
  name: "Surprise!",
  rating: 3,
  num: -1000,
}
