{
  num: 19,
  accuracy: 100,
  basePower: 90,
  category: "Physical",
  name: "Fly",
  pp: 15,
  priority: 0,
  flags: {
    contact: 1,
    charge: 1,
    protect: 1,
    mirror: 1,
    gravity: 1,
    distance: 1,
    metronome: 1,
    nosleeptalk: 1,
    noassist: 1,
    failinstruct: 1
  },
  onTryMove(attacker, defender, move) {
    if (attacker.removeVolatile(move.id)) {
      return;
    }
    this.add("-prepare", attacker, move.name);
    if (!this.runEvent("ChargeMove", attacker, defender, move)) {
      return;
    }
    attacker.addVolatile("twoturnmove", defender);
    return null;
  },
  condition: {
    duration: 2,
    onInvulnerability(target, source, move) {
      if (["gust", "twister", "skyuppercut", "thunder", "hurricane", "smackdown", "thousandarrows"].includes(move.id)) {
        return;
      }
      return false;
    },
    onSourceModifyDamage(damage, source, target, move) {
      if (move.id === "gust" || move.id === "twister") {
        return this.chainModify(2);
      }
    }
  },
  secondary: null,
  target: "any",
  type: "Flying",
  contestType: "Clever"
}