{
  num: 588,
  accuracy: true,
  basePower: 0,
  category: "Status",
  isNonstandard: "Past",
  name: "King's Shield",
  pp: 10,
  priority: 4,
  flags: { noassist: 1, failcopycat: 1, failinstruct: 1 },
  stallingMove: true,
  volatileStatus: "kingsshield",
  onPrepareHit(pokemon) {
    return !!this.queue.willAct() && this.runEvent("StallMove", pokemon);
  },
  onHit(pokemon) {
    pokemon.addVolatile("stall");
  },
  condition: {
    duration: 1,
    onStart(target) {
      this.add("-singleturn", target, "Protect");
    },
    onTryHitPriority: 3,
    onTryHit(target, source, move) {
      if (!move.flags["protect"] || move.category === "Status") {
        if (["gmaxoneblow", "gmaxrapidflow"].includes(move.id))
          return;
        if (move.isZ || move.isMax)
          target.getMoveHitData(move).zBrokeProtect = true;
        return;
      }
      if (move.smartTarget) {
        move.smartTarget = false;
      } else {
        this.add("-activate", target, "move: Protect");
      }
      const lockedmove = source.getVolatile("lockedmove");
      if (lockedmove) {
        if (source.volatiles["lockedmove"].duration === 2) {
          delete source.volatiles["lockedmove"];
        }
      }
      return this.NOT_FAIL;
    },
  },
  secondary: null,
  target: "self",
  type: "Steel",
  zMove: { effect: "clearnegativeboost" },
  contestType: "Cool"
}