{
  num: -1003,
  name: "Sonic Slash",
  pp: 10,
  priority: 0,
  accuracy: 100,
  basePower: 0, 
  category: "Physical",
  type: "Flying",
  target: "normal",
  flags: { contact: 1, protect: 1, mirror: 1 },
  secondary: null,
  contestType: "Cool",

  onBasePower(basePower, attacker, defender) {
    const attackerSpeed = attacker.getStat('spe', false, true);
    const defenderSpeed = defender.getStat('spe', false, true);

    if (attackerSpeed >= 3 * defenderSpeed) {
      return this.chainModify(1.4); 
    } else if (attackerSpeed >= 2 * defenderSpeed) {
      return this.chainModify(1.2); 
    } else {
      return this.chainModify(0.8);
    }
  },

  onPrepareHit(target, source, move) {
    const N = source.getStat('spe', false, true);
    const T = target.getStat('spe', false, true);

    if (N >= 3 * T) {
      move.basePower = 140;
    } else if (N >= 2 * T) {
      move.basePower = 120;
    } else {
      move.basePower = 80;
    }
    this.debug(`Sonic Slash base power set to ${move.basePower}`);
  },
} 