{
  num: 469,
  accuracy: true,
  basePower: 0,
  category: "Status",
  name: "Wide Guard",
  pp: 10,
  priority: 3,
  flags: { snatch: 1 },
  sideCondition: "wideguard",
  stallingMove: true,
  onPrepareHit(pokemon) {
    return !!this.queue.willAct() && this.runEvent("StallMove", pokemon);
  },
  onHit(pokemon) {
    pokemon.addVolatile("stall");
  },
  onTry() {
    return !!this.queue.willAct();
  },
  onHitSide(side, source) {
    source.addVolatile("stall");
  },
  condition: {
    duration: 1,
    onSideStart(target, source) {
      this.add("-singleturn", source, "Wide Guard");
    },
    onTryHitPriority: 4,
    onTryHit(target, source, move) {
      if (move?.target !== "allAdjacent" && move.target !== "allAdjacentFoes") {
        return;
      }
      if (move.isZ || move.isMax) {
        if (["gmaxoneblow", "gmaxrapidflow"].includes(move.id))
          return;
        target.getMoveHitData(move).zBrokeProtect = true;
        return;
      }
      this.add("-activate", target, "move: Wide Guard");
      const lockedmove = source.getVolatile("lockedmove");
      if (lockedmove) {
        if (source.volatiles["lockedmove"].duration === 2) {
          delete source.volatiles["lockedmove"];
        }
      }
      return this.NOT_FAIL;
    }
  },
  secondary: null,
  target: "allySide",
  type: "Rock",
  zMove: { boost: { def: 1 } },
  contestType: "Tough"
}