{
  onStart(pokemon) {
  	this.singleEvent('WeatherChange', this.effect, this.effectState, pokemon);
  },
  onWeatherChange(pokemon) {
  	if (!pokemon.isActive || pokemon.baseSpecies.baseSpecies !== 'Cherrim' || pokemon.transformed) return;
  	if (!pokemon.hp) return;
  	if (['sunnyday', 'desolateland'].includes(pokemon.effectiveWeather())) {
  		if (pokemon.species.id !== 'cherrimsunshine') {
  			pokemon.formeChange('Cherrim-Sunshine', this.effect, false, '[msg]');
  		}
  	} else {
  		if (pokemon.species.id === 'cherrimsunshine') {
  			pokemon.formeChange('Cherrim', this.effect, false, '[msg]');
  		}
  	}
  },
  onModifyAtkPriority: 3,
  onModifyAtk(atk, pokemon) {
  	if (this.effectState.target.baseSpecies.baseSpecies !== 'Cherrim') return;
  	if (['sunnyday', 'desolateland'].includes(pokemon.effectiveWeather())) {
  		return this.chainModify(1.5);
  	}
  },
  onModifySpePriority: 4,
  onModifySpe(spd, pokemon) {
  	if (this.effectState.target.baseSpecies.baseSpecies !== 'Cherrim') return;
  	if (['sunnyday', 'desolateland'].includes(pokemon.effectiveWeather())) {
  		return this.chainModify(1.5);
  	}
  },
  flags: { failroleplay: 1, noreceiver: 1, noentrain: 1, notrace: 1, breakable: 1 },
  name: "Flower Gift",
  rating: 1,
  num: 122,
}
