{
  onDamagingHit(damage, target, source, move) {
  	if (!source.hp || !source.isActive || target.isSemiInvulnerable()) return;
  	if (['cramorantgulping', 'cramorantgorging'].includes(target.species.id)) {
  		this.damage(source.baseMaxhp / 4, source, target);
  		if (target.species.id === 'cramorantgulping') {
  			this.boost({ spe: -1 }, source, target, null, true);
  		} else {
  			source.trySetStatus('par', target, move);
  		}
  		target.formeChange('cramorant', move);
  	}
  },
  onSourceTryPrimaryHit(target, source, effect) {
  	if (effect?.id === 'surf' && source.hasAbility('gulpmissile') && source.species.name === 'Cramorant') {
  		const forme = source.hp <= source.maxhp / 2 ? 'cramorantgorging' : 'cramorantgulping';
  		source.formeChange(forme, effect);
  	}
  },
  flags: { cantsuppress: 1, notransform: 1 },
  name: "Gulp Missile",
  rating: 2.5,
  num: 241,
}