{
  name: 'frz',
  effectType: 'Status',
  onStart(target, source, sourceEffect) {
    if (sourceEffect?.effectType === 'Ability') {
      this.add('-status', target, 'frz', '[from] ability: ' + sourceEffect.name, '[of] ' + source);
    } else {
      this.add('-status', target, 'frz');
    }
  },
  onResidualOrder: 10,
  onResidual(pokemon) {
    const hasThickFat = pokemon.hasAbility('thickfat');
    if (hasThickFat) {
      this.damage(pokemon.baseMaxhp / 32);
      return;
    }
    const weather = this.field.weather;
    const isCold = weather === 'hail' || weather === 'snow';
    const damageFraction = isCold ? 8 : 16;
    this.damage(pokemon.baseMaxhp / damageFraction);
  },
  onModifyMove(move, source, target) {
    if (source.status === 'frz' && move.category === 'Special' && move.basePower) {
      this.debug('Freezing halves special move base power');
      move.basePower = Math.floor(move.basePower / 2);
    }
  },
}