{
  name: "Leppa Berry",
  spritenum: 244,
  isBerry: true,
  naturalGift: {
  	basePower: 80,
  	type: "Fighting",
  },
  onUpdate(pokemon) {
  	if (!pokemon.hp) return;
  	if (pokemon.moveSlots.some(move => move.pp === 0)) {
  		pokemon.eatItem();
  	}
  },
  onEat(pokemon) {
  	const moveSlot = pokemon.moveSlots.find(move => move.pp === 0) ||
  		pokemon.moveSlots.find(move => move.pp < move.maxpp);
  	if (!moveSlot) return;
  	moveSlot.pp += 10;
  	if (moveSlot.pp > moveSlot.maxpp) moveSlot.pp = moveSlot.maxpp;
  	this.add('-activate', pokemon, 'item: Leppa Berry', moveSlot.move, '[consumed]');
  },
  num: 154,
  gen: 3,
}