/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConfigLogger {
    public static final ConfigLogger EMPTY = new ConfigLogger(){

        @Override
        public void logInfo(@NotNull String msg) {
        }

        @Override
        public void logWarn(@NotNull String msg) {
        }

        @Override
        public void logError(@NotNull String msg) {
        }
    };
    public static final ConfigLogger SIMPLE = new ConfigLogger(){

        @Override
        public void logInfo(@NotNull String msg) {
            System.out.println("INFO: " + msg);
        }

        @Override
        public void logWarn(@NotNull String msg) {
            System.out.println("WARN: " + msg);
        }

        @Override
        public void logError(@NotNull String msg) {
            System.out.println("ERROR: " + msg);
        }
    };

    public void logInfo(@NotNull String var1);

    public void logWarn(@NotNull String var1);

    public void logError(@NotNull String var1);

    default public void logError(@Nullable String msg, @NotNull Throwable t) {
        if (msg != null) {
            this.logError(msg);
        }
        for (StackTraceElement element : t.getStackTrace()) {
            this.logError(element.toString());
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            this.logError("Caused by: " + cause);
        }
        for (Throwable suppressed : t.getSuppressed()) {
            this.logError(null, suppressed);
        }
    }
}

