/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderContext;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderList;
import me.phoenixra.atumconfig.api.utils.Objects;
import me.phoenixra.atumconfig.api.utils.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Config
extends PlaceholderList {
    public ConfigManager getConfigOwner();

    @NotNull
    public ConfigType getType();

    default public Map<String, Object> toMap() {
        return new HashMap<String, Object>();
    }

    public String toPlaintext();

    public boolean hasPath(@NotNull String var1);

    @NotNull
    public List<String> getKeys(boolean var1);

    @NotNull
    default public List<String> recurseKeys(@NotNull Set<String> found, @NotNull String root) {
        return Collections.emptyList();
    }

    @NotNull
    public Map<String, Config> getAllSubsections();

    public void applyData(@NotNull Map<String, Object> var1);

    default public void applyData(Config config) {
        this.applyData(config.toMap());
    }

    @Nullable
    public Object get(@NotNull String var1);

    public void set(@NotNull String var1, @Nullable Object var2);

    default public byte getByte(@NotNull String path) {
        return Objects.requireNonNullElse(this.getByteOrNull(path), (byte)0);
    }

    default public byte getByteOrDefault(@NotNull String path, byte def) {
        return Objects.requireNonNullElse(this.getByteOrNull(path), def);
    }

    @Nullable
    public Byte getByteOrNull(@NotNull String var1);

    @NotNull
    default public List<Byte> getByteList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getByteListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Byte> getByteListOrNull(@NotNull String var1);

    default public short getShort(@NotNull String path) {
        return Objects.requireNonNullElse(this.getShortOrNull(path), (short)0);
    }

    default public short getShortOrDefault(@NotNull String path, short def) {
        return Objects.requireNonNullElse(this.getShortOrNull(path), def);
    }

    @Nullable
    public Short getShortOrNull(@NotNull String var1);

    @NotNull
    default public List<Short> getShortList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getShortListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Short> getShortListOrNull(@NotNull String var1);

    default public int getInt(@NotNull String path) {
        return Objects.requireNonNullElse(this.getIntOrNull(path), 0);
    }

    default public int getIntOrDefault(@NotNull String path, int def) {
        return Objects.requireNonNullElse(this.getIntOrNull(path), def);
    }

    @Nullable
    public Integer getIntOrNull(@NotNull String var1);

    @NotNull
    default public List<Integer> getIntList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getIntListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Integer> getIntListOrNull(@NotNull String var1);

    default public long getLong(@NotNull String path) {
        return Objects.requireNonNullElse(this.getLongOrNull(path), 0L);
    }

    default public long getLongOrDefault(@NotNull String path, long def) {
        return Objects.requireNonNullElse(this.getLongOrNull(path), def);
    }

    @Nullable
    public Long getLongOrNull(@NotNull String var1);

    @NotNull
    default public List<Long> getLongList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getLongListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Long> getLongListOrNull(@NotNull String var1);

    default public float getFloat(@NotNull String path) {
        return Objects.requireNonNullElse(this.getFloatOrNull(path), Float.valueOf(0.0f)).floatValue();
    }

    default public float getFloatOrDefault(@NotNull String path, float def) {
        return Objects.requireNonNullElse(this.getFloatOrNull(path), Float.valueOf(def)).floatValue();
    }

    @Nullable
    public Float getFloatOrNull(@NotNull String var1);

    @NotNull
    default public List<Float> getFloatList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getFloatListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Float> getFloatListOrNull(@NotNull String var1);

    default public double getDouble(@NotNull String path) {
        return Objects.requireNonNullElse(this.getDoubleOrNull(path), 0.0);
    }

    default public double getDoubleOrDefault(@NotNull String path, double def) {
        return Objects.requireNonNullElse(this.getDoubleOrNull(path), def);
    }

    @Nullable
    public Double getDoubleOrNull(@NotNull String var1);

    @NotNull
    default public List<Double> getDoubleList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getDoubleListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Double> getDoubleListOrNull(@NotNull String var1);

    default public boolean getBool(@NotNull String path) {
        return Objects.requireNonNullElse(this.getBoolOrNull(path), false);
    }

    default public boolean getBoolOrDefault(@NotNull String path, boolean def) {
        return Objects.requireNonNullElse(this.getBoolOrNull(path), def);
    }

    @Nullable
    public Boolean getBoolOrNull(@NotNull String var1);

    @NotNull
    default public List<Boolean> getBoolList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getBoolListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<Boolean> getBoolListOrNull(@NotNull String var1);

    @NotNull
    default public String getString(@NotNull String path) {
        return this.getStringOrDefault(path, "");
    }

    @NotNull
    default public String getStringOrDefault(@NotNull String path, @NotNull String def) {
        return Objects.requireNonNullElse(this.getStringOrNull(path), def);
    }

    @Nullable
    public String getStringOrNull(@NotNull String var1);

    @NotNull
    default public List<String> getStringList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getStringListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<String> getStringListOrNull(@NotNull String var1);

    @NotNull
    default public String getFormattedString(@NotNull String path) {
        return Objects.requireNonNullElse(this.getFormattedStringOrNull(path, null), "");
    }

    @NotNull
    default public String getFormattedString(@NotNull String path, @Nullable PlaceholderContext context) {
        return Objects.requireNonNullElse(this.getFormattedStringOrNull(path, context), "");
    }

    @Nullable
    default public String getFormattedStringOrNull(@NotNull String path) {
        return this.getFormattedString(path, null);
    }

    @Nullable
    default public String getFormattedStringOrNull(@NotNull String path, @Nullable PlaceholderContext context) {
        String text = this.getStringOrNull(path);
        if (text == null) {
            return null;
        }
        return StringUtils.formatWithPlaceholders(this.getConfigOwner(), this.getConfigOwner().supportsColorCodes() ? StringUtils.formatColorCodes(text) : text, context != null ? context.withContext(this) : new PlaceholderContext(this));
    }

    @NotNull
    default public List<String> getFormattedStringList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getFormattedStringListOrNull(path, null), new ArrayList());
    }

    @NotNull
    default public List<String> getFormattedStringList(@NotNull String path, @Nullable PlaceholderContext context) {
        return Objects.requireNonNullElse(this.getFormattedStringListOrNull(path, context), new ArrayList());
    }

    @Nullable
    default public List<String> getFormattedStringListOrNull(@NotNull String path) {
        return this.getFormattedStringListOrNull(path, null);
    }

    @Nullable
    default public List<String> getFormattedStringListOrNull(@NotNull String path, @Nullable PlaceholderContext context) {
        List<String> list = this.getStringListOrNull(path);
        if (list == null) {
            return null;
        }
        if (context == null) {
            return StringUtils.formatWithPlaceholders(this.getConfigOwner(), this.getConfigOwner().supportsColorCodes() ? StringUtils.formatColorCodes(list) : list, new PlaceholderContext(this));
        }
        return StringUtils.formatWithPlaceholders(this.getConfigOwner(), this.getConfigOwner().supportsColorCodes() ? StringUtils.formatColorCodes(list) : list, context.withContext(this));
    }

    @NotNull
    default public Config getSubsection(@NotNull String path) {
        return Objects.requireNonNullElse(this.getSubsectionOrNull(path), this.getConfigOwner().createConfig(this.getType(), null));
    }

    @Nullable
    public Config getSubsectionOrNull(@NotNull String var1);

    @NotNull
    default public List<? extends Config> getSubsectionList(@NotNull String path) {
        return Objects.requireNonNullElse(this.getSubsectionListOrNull(path), new ArrayList());
    }

    @Nullable
    public List<? extends Config> getSubsectionListOrNull(@NotNull String var1);

    default public <T> T getParsedOrDefault(@NotNull String path, Class<T> clazz, T def) {
        return Objects.requireNonNullElse(this.getParsedOrNull(path, clazz), def);
    }

    @Nullable
    public <T> T getParsedOrNull(@NotNull String var1, Class<T> var2);

    @NotNull
    default public <T> List<T> getParsedList(@NotNull String path, Class<T> clazz) {
        return Objects.requireNonNullElse(this.getParsedListOrNull(path, clazz), new ArrayList());
    }

    @Nullable
    public <T> List<T> getParsedListOrNull(@NotNull String var1, Class<T> var2);

    default public double getEvaluated(@NotNull String path) {
        return this.getEvaluated(path, PlaceholderContext.EMPTY);
    }

    public double getEvaluated(@NotNull String var1, @NotNull PlaceholderContext var2);
}

