/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.config;

import java.io.File;
import org.jetbrains.annotations.Nullable;

public enum ConfigType {
    JSON("json"),
    YAML("yml");

    private final String fileExtension;

    private ConfigType(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Nullable
    public static ConfigType fromFile(File file) {
        String ext;
        String name = file.getName();
        String[] parts = name.split("\\.");
        switch (ext = parts.length > 1 ? parts[parts.length - 1] : "") {
            case "yml": {
                return YAML;
            }
            case "json": {
                return JSON;
            }
        }
        return null;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }
}

