/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.placeholders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.phoenixra.atumconfig.api.ConfigLogger;
import me.phoenixra.atumconfig.api.placeholders.Placeholder;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderContext;
import org.jetbrains.annotations.NotNull;

public interface PlaceholderHandler {
    public static final Pattern PATTERN = Pattern.compile("%([^% ]+)%");
    public static final PlaceholderHandler EMPTY = new PlaceholderHandler(){

        @Override
        public void unregisterGlobalPlaceholder(@NotNull Placeholder placeholder) {
        }

        @Override
        public void registerGlobalPlaceholder(@NotNull Placeholder placeholder) {
        }

        @Override
        @NotNull
        public Set<Placeholder> getGlobalPlaceholders() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public String translatePlaceholders(@NotNull String text) {
            return text;
        }

        @Override
        @NotNull
        public String translatePlaceholders(@NotNull String text, @NotNull PlaceholderContext context) {
            return text;
        }

        @Override
        @NotNull
        public ConfigLogger getLogger() {
            return ConfigLogger.EMPTY;
        }
    };

    public void registerGlobalPlaceholder(@NotNull Placeholder var1);

    public void unregisterGlobalPlaceholder(@NotNull Placeholder var1);

    @NotNull
    public Set<Placeholder> getGlobalPlaceholders();

    @NotNull
    public String translatePlaceholders(@NotNull String var1);

    @NotNull
    public String translatePlaceholders(@NotNull String var1, @NotNull PlaceholderContext var2);

    @NotNull
    public ConfigLogger getLogger();

    @NotNull
    public static List<String> findPlaceholdersIn(@NotNull String text) {
        HashSet<String> found = new HashSet<String>();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            found.add(matcher.group());
        }
        return new ArrayList<String>(found);
    }
}

