/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.placeholders.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.phoenixra.atumconfig.api.placeholders.Placeholder;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderListMerged
implements PlaceholderList {
    private final PlaceholderList baseContext;
    private final PlaceholderList additionalContext;
    private final Set<Placeholder> extraInjections = new HashSet<Placeholder>();

    public PlaceholderListMerged(@NotNull PlaceholderList baseContext, @NotNull PlaceholderList additionalContext) {
        this.baseContext = baseContext;
        this.additionalContext = additionalContext;
    }

    @Override
    public void addPlaceholder(@NotNull Iterable<Placeholder> placeholders, boolean deep) {
        for (Placeholder placeholder : placeholders) {
            this.extraInjections.add(placeholder);
        }
        if (deep) {
            this.baseContext.addPlaceholder(placeholders, deep);
            this.additionalContext.addPlaceholder(placeholders, deep);
        }
    }

    @Override
    public void removePlaceholder(@NotNull Iterable<Placeholder> placeholders, boolean deep) {
        for (Placeholder placeholder : placeholders) {
            this.extraInjections.remove(placeholder);
        }
        if (deep) {
            this.baseContext.removePlaceholder(placeholders, deep);
            this.additionalContext.removePlaceholder(placeholders, deep);
        }
    }

    @Override
    public void clearPlaceholders(boolean deep) {
        this.extraInjections.clear();
        if (deep) {
            this.baseContext.clearPlaceholders(deep);
            this.additionalContext.clearPlaceholders(deep);
        }
    }

    @Override
    @NotNull
    public List<Placeholder> getPlaceholders() {
        List<Placeholder> base = this.baseContext.getPlaceholders();
        List<Placeholder> additional = this.additionalContext.getPlaceholders();
        ArrayList<Placeholder> injections = new ArrayList<Placeholder>(base.size() + additional.size() + this.extraInjections.size());
        injections.addAll(base);
        injections.addAll(additional);
        injections.addAll(this.extraInjections);
        return injections;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlaceholderListMerged)) {
            return false;
        }
        PlaceholderListMerged that = (PlaceholderListMerged)o;
        return Objects.equals(this.baseContext, that.baseContext) && Objects.equals(this.additionalContext, that.additionalContext) && Objects.equals(this.extraInjections, that.extraInjections);
    }

    public int hashCode() {
        return Objects.hash(this.baseContext, this.additionalContext, this.extraInjections);
    }
}

