/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.placeholders.types;

import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import me.phoenixra.atumconfig.api.placeholders.Placeholder;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicPlaceholder
implements Placeholder {
    private final Pattern pattern;
    private final Function<@NotNull String, @Nullable String> function;

    public DynamicPlaceholder(@NotNull Pattern innerPattern, @NotNull @NotNull Function<@NotNull String, @Nullable String> function) {
        this.pattern = Pattern.compile("%(" + innerPattern.pattern() + ")%");
        this.function = function;
    }

    @Override
    @Nullable
    public String getValue(@NotNull String replacing, @NotNull PlaceholderContext context) {
        return this.function.apply(replacing);
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicPlaceholder)) {
            return false;
        }
        DynamicPlaceholder that = (DynamicPlaceholder)o;
        return Objects.equals(this.getPattern(), that.getPattern());
    }

    public int hashCode() {
        return Objects.hash(this.getPattern());
    }
}

