/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.api.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.placeholders.PlaceholderHandler;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderContext;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.atumconfig.api.utils.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    private StringUtils() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    @NotNull
    public static String formatColorCodes(@NotNull String text) {
        return StringUtils.replaceFast(text, "&", "\u00a7");
    }

    @NotNull
    public static Collection<String> formatColorCodes(@NotNull Collection<String> list) {
        ArrayList<String> output = new ArrayList<String>();
        for (String entry : list) {
            output.add(StringUtils.formatColorCodes(entry));
        }
        return output;
    }

    @NotNull
    public static String formatWithPlaceholders(@NotNull ConfigManager configOwner, @NotNull String text, @NotNull PlaceholderContext context) {
        return configOwner.getPlaceholderHandler().orElse(PlaceholderHandler.EMPTY).translatePlaceholders(text, context);
    }

    @NotNull
    public static List<String> formatWithPlaceholders(@NotNull ConfigManager configOwner, @NotNull Collection<String> list, @NotNull PlaceholderContext context) {
        ArrayList<String> out = new ArrayList<String>();
        PlaceholderHandler placeholderHandler = configOwner.getPlaceholderHandler().orElse(PlaceholderHandler.EMPTY);
        for (String line : list) {
            out.add(placeholderHandler.translatePlaceholders(line, context));
        }
        return out;
    }

    @NotNull
    public static String removeColorCodes(String input) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (currentChar == '\u00a7' || currentChar == '&') {
                ++i;
                continue;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    @NotNull
    public static String replaceFast(@NotNull String input, @NotNull List<PairRecord<String, String>> placeholder) {
        String out = input;
        for (PairRecord<String, String> pair : placeholder) {
            out = StringUtils.replaceFast(out, pair.first(), pair.second());
        }
        return out;
    }

    @NotNull
    public static String replaceFast(@NotNull String input, @NotNull String target, @NotNull String replacement) {
        int targetLength = target.length();
        int count = 0;
        int index = input.indexOf(target);
        while (index != -1) {
            ++count;
            index = input.indexOf(target, index + targetLength);
        }
        if (count == 0) {
            return input;
        }
        int replacementLength = replacement.length();
        int inputLength = input.length();
        int newSize = inputLength + (replacementLength - targetLength) * count;
        StringBuilder result = new StringBuilder(newSize);
        int start = 0;
        int index2 = input.indexOf(target);
        while (index2 != -1) {
            result.append(input, start, index2);
            result.append(replacement);
            start = index2 + targetLength;
            index2 = input.indexOf(target, start);
        }
        result.append(input, start, inputLength);
        return result.toString();
    }

    public static String toNiceString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Integer) {
            return ((Integer)object).toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Double) {
            return NumberUtils.format((Double)object);
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(StringUtils::toNiceString).collect(Collectors.joining(", "));
        }
        return String.valueOf(object);
    }
}

