/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.core;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import me.phoenixra.atumconfig.api.ConfigLogger;
import me.phoenixra.atumconfig.api.placeholders.Placeholder;
import me.phoenixra.atumconfig.api.placeholders.PlaceholderHandler;
import me.phoenixra.atumconfig.api.placeholders.context.PlaceholderContext;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.atumconfig.api.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AtumPlaceholderHandler
implements PlaceholderHandler {
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final ConfigLogger logger;
    private final Set<Placeholder> globalPlaceholders = new CopyOnWriteArraySet<Placeholder>();

    public AtumPlaceholderHandler(@NotNull ConfigLogger logger) {
        this.logger = logger;
    }

    @Override
    @NotNull
    public String translatePlaceholders(@NotNull String text) {
        return this.translatePlaceholders(text, PlaceholderContext.EMPTY);
    }

    @Override
    @NotNull
    public String translatePlaceholders(@NotNull String text, @NotNull PlaceholderContext context) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (String textToReplace : PlaceholderHandler.findPlaceholdersIn(text)) {
            Future future = EXECUTOR.submit(() -> {
                for (Placeholder placeholder : context.placeholderList().getPlaceholders()) {
                    if (!textToReplace.matches(placeholder.getPattern().pattern())) continue;
                    String replacement = placeholder.getValue(textToReplace, context);
                    if (replacement == null) {
                        return new PairRecord<String, String>("", "");
                    }
                    return new PairRecord<String, String>(textToReplace, replacement);
                }
                for (Placeholder placeholder : this.globalPlaceholders) {
                    if (!textToReplace.matches(placeholder.getPattern().pattern())) continue;
                    String replacement = placeholder.getValue(textToReplace, context);
                    if (replacement == null) {
                        return new PairRecord<String, String>("", "");
                    }
                    return new PairRecord<String, String>(textToReplace, replacement);
                }
                return new PairRecord<String, String>("", "");
            });
            futures.add(future);
        }
        String translated = text;
        for (Future future : futures) {
            try {
                PairRecord result = (PairRecord)future.get();
                if (((String)result.first()).isEmpty()) continue;
                translated = StringUtils.replaceFast(translated, (String)result.first(), (String)result.second());
            }
            catch (InterruptedException | ExecutionException e) {
                this.getLogger().logError("Placeholders exception ", e);
            }
        }
        return translated;
    }

    @Override
    public void registerGlobalPlaceholder(@NotNull Placeholder placeholder) {
        this.globalPlaceholders.add(placeholder);
    }

    @Override
    public void unregisterGlobalPlaceholder(@NotNull Placeholder placeholder) {
        this.globalPlaceholders.remove(placeholder);
    }

    @Override
    public ConfigLogger getLogger() {
        return this.logger;
    }

    @Override
    public Set<Placeholder> getGlobalPlaceholders() {
        return this.globalPlaceholders;
    }
}

