/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.core.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalog;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalogListener;
import me.phoenixra.atumconfig.api.utils.FileUtils;
import me.phoenixra.atumconfig.core.config.AtumConfigFile;
import org.jetbrains.annotations.NotNull;

public class AtumConfigCatalog
implements ConfigCatalog {
    private final ConfigManager configManager;
    private final ConfigType type;
    private final String id;
    private final Path directory;
    private final ConfigCatalogListener listener;
    private final boolean nestedDirectories;
    protected Map<String, ConfigFile> configFilesMap = new ConcurrentHashMap<String, ConfigFile>();

    public AtumConfigCatalog(@NotNull ConfigManager configManager, @NotNull ConfigType type, @NotNull String id, @NotNull Path relativeDirectory, boolean nested, @NotNull ConfigCatalogListener catalogListener) {
        this.configManager = configManager;
        this.type = type;
        this.id = id;
        this.directory = relativeDirectory;
        this.listener = catalogListener;
        this.nestedDirectories = nested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        this.listener.beforeReload();
        this.listener.onClear();
        this.configFilesMap.clear();
        Path baseDir = this.configManager.getDirectory().resolve(this.directory);
        this.configManager.getLogger().logInfo("Reloading catalog '" + this.id + "' from " + baseDir);
        if (Files.notExists(baseDir, new LinkOption[0])) {
            this.loadDefaults();
        }
        try (Stream<Path> stream = this.nestedDirectories ? Files.walk(baseDir, new FileVisitOption[0]) : Files.list(baseDir);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(this.type.getFileExtension())).forEach(path -> {
                Path relParent = baseDir.relativize(path.getParent());
                String filename = path.getFileName().toString();
                int dot = filename.lastIndexOf(46);
                String nameNoExt = dot == -1 ? filename : filename.substring(0, dot);
                Path idPath = relParent.resolve(nameNoExt);
                String configId = idPath.toString().replace(File.separatorChar, '/');
                Path relativeFile = this.directory.resolve(relParent).resolve(path.getFileName());
                try {
                    AtumConfigFile conf = new AtumConfigFile(this.configManager, this.type, configId, relativeFile, false);
                    this.configFilesMap.put(configId, conf);
                    this.listener.onConfigLoaded(conf);
                }
                catch (Throwable e) {
                    this.configManager.getLogger().logError("Failed to load config '" + filename + "' in catalog '" + this.id + "'", e);
                    this.listener.onConfigFailed(relativeFile, e);
                }
            });
        }
        catch (IOException e) {
            this.configManager.getLogger().logError("Failed scanning catalog directory: " + baseDir, e);
        }
        finally {
            this.listener.afterReload();
        }
    }

    private void loadDefaults() {
        this.listener.beforeLoadDefaults();
        Path root = this.configManager.getDirectory();
        for (String resourcePath : FileUtils.getAllPathsInResourceFolder(this.configManager, this.directory)) {
            Path target = root.resolve(resourcePath);
            try {
                if (!resourcePath.contains(".")) {
                    Files.createDirectories(target, new FileAttribute[0]);
                    continue;
                }
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
                Throwable throwable = null;
                try {
                    if (in == null) {
                        this.configManager.getLogger().logWarn("Default resource not found: " + resourcePath);
                        continue;
                    }
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    this.configManager.getLogger().logInfo("Copying default resource: " + resourcePath);
                    Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                this.configManager.getLogger().logError("Error loading default for resource: " + resourcePath, e);
            }
        }
        this.listener.afterLoadDefaults();
    }

    @Override
    @NotNull
    public Optional<ConfigFile> getConfigFile(@NotNull String id) {
        return Optional.ofNullable(this.configFilesMap.get(id));
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public ConfigType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public ConfigCatalogListener getListener() {
        return this.listener;
    }

    @Override
    public boolean isNestedDirectories() {
        return this.nestedDirectories;
    }

    @Override
    public Map<String, ConfigFile> getConfigFilesMap() {
        return this.configFilesMap;
    }
}

