/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumconfig.core.config.typehandlers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.config.ConfigParser;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.core.config.AtumConfigSection;
import me.phoenixra.atumconfig.core.config.typehandlers.ConfigTypeHandlers;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigTypeHandler {
    private ConfigType type;

    public ConfigTypeHandler(ConfigType type) {
        this.type = type;
    }

    public Map<String, Object> toMap(ConfigManager configOwner, String input) {
        if (input == null || input.replace(" ", "").isEmpty()) {
            return new HashMap<String, Object>();
        }
        return ConfigTypeHandler.normalizeToConfig(configOwner, this.type, this.parseToMap(input));
    }

    protected abstract Map<String, Object> parseToMap(String var1);

    public abstract String toString(Map<String, Object> var1);

    public static Map<String, Object> toMap(ConfigManager configOwner, @NotNull ConfigType type, @NotNull String input) {
        return ConfigTypeHandlers.HANDLERS.get((Object)type).toMap(configOwner, input);
    }

    public static String toString(@NotNull ConfigType type, @NotNull Map<String, Object> map) {
        return ConfigTypeHandlers.HANDLERS.get((Object)type).toString(map);
    }

    public static String toString(InputStream inputStream) throws IOException {
        String str;
        InputStreamReader isReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuffer sb = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static Object constrainConfigTypes(ConfigManager configOwner, @NotNull ConfigType type, Object input) {
        if (input == null) {
            return null;
        }
        @NotNull Optional<ConfigParser<?>> parser = configOwner.getConfigParser(input.getClass());
        if (parser.isPresent()) {
            AtumConfigSection section = new AtumConfigSection(configOwner, type, null);
            return parser.get().toConfig(input, section);
        }
        if (input instanceof Map) {
            Map rawMap = (Map)input;
            Map<String, Object> normalized = ConfigTypeHandler.normalizeToConfig(configOwner, type, rawMap);
            return new AtumConfigSection(configOwner, type, normalized);
        }
        if (input instanceof Iterable) {
            Iterable iterable = (Iterable)input;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object elem : iterable) {
                list.add(ConfigTypeHandler.constrainConfigTypes(configOwner, type, elem));
            }
            return list;
        }
        return input;
    }

    public static Map<String, Object> normalizeToConfig(ConfigManager configOwner, @NotNull ConfigType type, @NotNull Map<?, ?> raw) {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : raw.entrySet()) {
            String key = entry.getKey().toString();
            Object val = entry.getValue();
            out.put(key, ConfigTypeHandler.constrainConfigTypes(configOwner, type, val));
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readToString(@NotNull Reader input) {
        try (BufferedReader reader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
            String string = builder.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

