/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.api.misc.color;

import java.awt.Color;
import me.phoenixra.atumvr.api.misc.color.AtumColorImmutable;
import me.phoenixra.atumvr.api.misc.color.AtumColorMutable;
import org.jetbrains.annotations.NotNull;

public interface AtumColor {
    public static final String COLOR_SYMBOL = "\u00a7";
    public static final AtumColorImmutable WHITE = AtumColor.immutable(1.0f, 1.0f, 1.0f, 1.0f);
    public static final AtumColorImmutable BLACK = AtumColor.immutable(0.0f, 0.0f, 0.0f, 1.0f);
    public static final AtumColorImmutable RED = AtumColor.immutable(1.0f, 0.0f, 0.0f, 1.0f);
    public static final AtumColorImmutable GREEN = AtumColor.immutable(0.0f, 1.0f, 0.0f, 1.0f);
    public static final AtumColorImmutable BLUE = AtumColor.immutable(0.0f, 0.0f, 1.0f, 1.0f);
    public static final AtumColorImmutable YELLOW = AtumColor.immutable(1.0f, 1.0f, 0.0f, 1.0f);
    public static final AtumColorImmutable CYAN = AtumColor.immutable(0.0f, 1.0f, 1.0f, 1.0f);
    public static final AtumColorImmutable MAGENTA = AtumColor.immutable(1.0f, 0.0f, 1.0f, 1.0f);
    public static final AtumColorImmutable GRAY = AtumColor.immutable(0.5f, 0.5f, 0.5f, 1.0f);
    public static final AtumColorImmutable DARK_GRAY = AtumColor.immutable(0.25f, 0.25f, 0.25f, 1.0f);
    public static final AtumColorImmutable LIGHT_GRAY = AtumColor.immutable(0.75f, 0.75f, 0.75f, 1.0f);
    public static final AtumColorImmutable ORANGE = AtumColor.immutable(1.0f, 0.5f, 0.0f, 1.0f);
    public static final AtumColorImmutable PINK = AtumColor.immutable(1.0f, 0.68f, 0.68f, 1.0f);
    public static final AtumColorImmutable PURPLE = AtumColor.immutable(0.5f, 0.0f, 0.5f, 1.0f);
    public static final AtumColorImmutable BROWN = AtumColor.immutable(0.5f, 0.25f, 0.0f, 1.0f);
    public static final AtumColorImmutable LIME = AtumColor.immutableFromHex("#39FF14");

    public float getRed();

    public float getGreen();

    public float getBlue();

    public float getAlpha();

    public int getRedInt();

    public int getGreenInt();

    public int getBlueInt();

    public int getAlphaInt();

    @NotNull
    public AtumColor blend(@NotNull AtumColor var1, float var2);

    @NotNull
    public AtumColor multiply(float var1);

    @NotNull
    public AtumColor invert();

    @NotNull
    public AtumColor toGrayscale();

    public double getContrastRatio(@NotNull AtumColor var1);

    @NotNull
    public AtumColor withAlpha(float var1);

    @NotNull
    default public AtumColor lighten(float factor) {
        return this.blend(WHITE, factor);
    }

    @NotNull
    default public AtumColor darken(float factor) {
        return this.blend(BLACK, factor);
    }

    @NotNull
    default public AtumColor lerp(@NotNull AtumColor other, float t) {
        return this.blend(other, t);
    }

    default public float[] toHSB() {
        return Color.RGBtoHSB(this.getRedInt(), this.getGreenInt(), this.getBlueInt(), null);
    }

    default public int toInt() {
        return this.getRedInt() << 16 | this.getGreenInt() << 8 | this.getBlueInt() | this.getAlphaInt() << 24;
    }

    @NotNull
    default public String toHex(boolean withAlpha) {
        if (withAlpha) {
            return String.format("#%02x%02x%02x%02x", this.getRedInt(), this.getGreenInt(), this.getBlueInt(), this.getAlphaInt());
        }
        return String.format("#%02x%02x%02x", this.getRedInt(), this.getGreenInt(), this.getBlueInt());
    }

    @NotNull
    default public Color asAwtColor() {
        return new Color(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    default public int floatToInt(float value) {
        if (value <= 0.0f) {
            return 0;
        }
        if (value >= 1.0f) {
            return 255;
        }
        return (int)(value * 255.0f);
    }

    @NotNull
    public static AtumColorMutable mutable(float red, float green, float blue, float alpha) {
        return new AtumColorMutable(red, green, blue, alpha);
    }

    @NotNull
    public static AtumColorMutable mutable(int red, int green, int blue, int alpha) {
        return new AtumColorMutable(red, green, blue, alpha);
    }

    @NotNull
    public static AtumColorMutable mutableFromHex(String hex) {
        float[] values = AtumColor.valuesFromHex(hex);
        return new AtumColorMutable(values[0], values[1], values[2], values[3]);
    }

    @NotNull
    public static AtumColorImmutable immutable(float red, float green, float blue, float alpha) {
        return new AtumColorImmutable(red, green, blue, alpha);
    }

    @NotNull
    public static AtumColorImmutable immutable(int red, int green, int blue, int alpha) {
        return new AtumColorImmutable(red, green, blue, alpha);
    }

    @NotNull
    public static AtumColorImmutable immutableFromHex(String hex) {
        float[] values = AtumColor.valuesFromHex(hex);
        return new AtumColorImmutable(values[0], values[1], values[2], values[3]);
    }

    public static float[] valuesFromHex(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() == 6) {
            int r = Integer.parseInt(hex.substring(0, 2), 16);
            int g = Integer.parseInt(hex.substring(2, 4), 16);
            int b = Integer.parseInt(hex.substring(4, 6), 16);
            return new float[]{r, g, b, 255.0f};
        }
        if (hex.length() == 8) {
            int r = Integer.parseInt(hex.substring(0, 2), 16);
            int g = Integer.parseInt(hex.substring(2, 4), 16);
            int b = Integer.parseInt(hex.substring(4, 6), 16);
            int a = Integer.parseInt(hex.substring(6, 8), 16);
            return new float[]{r, g, b, a};
        }
        throw new IllegalArgumentException("Invalid hex format");
    }
}

