/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.api.misc.color;

import java.util.Objects;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.atumvr.api.misc.color.AtumColorMutable;
import org.jetbrains.annotations.NotNull;

public class AtumColorImmutable
implements AtumColor {
    private final float red;
    private final float green;
    private final float blue;
    private final float alpha;
    private final int redInt;
    private final int greenInt;
    private final int blueInt;
    private final int alphaInt;

    public AtumColorImmutable(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.redInt = this.floatToInt(red);
        this.greenInt = this.floatToInt(green);
        this.blueInt = this.floatToInt(blue);
        this.alphaInt = this.floatToInt(alpha);
    }

    public AtumColorImmutable(int red, int green, int blue, int alpha) {
        this.red = (float)red / 255.0f;
        this.green = (float)green / 255.0f;
        this.blue = (float)blue / 255.0f;
        this.alpha = (float)alpha / 255.0f;
        this.redInt = this.floatToInt(this.red);
        this.greenInt = this.floatToInt(this.green);
        this.blueInt = this.floatToInt(this.blue);
        this.alphaInt = this.floatToInt(this.alpha);
    }

    @Override
    @NotNull
    public AtumColorImmutable blend(@NotNull AtumColor other, float ratio) {
        float newRed = this.red * (1.0f - ratio) + other.getRed() * ratio;
        float newGreen = this.green * (1.0f - ratio) + other.getGreen() * ratio;
        float newBlue = this.blue * (1.0f - ratio) + other.getBlue() * ratio;
        float newAlpha = this.alpha * (1.0f - ratio) + other.getAlpha() * ratio;
        return new AtumColorImmutable(newRed, newGreen, newBlue, newAlpha);
    }

    @Override
    @NotNull
    public AtumColorImmutable multiply(float multiplier) {
        return new AtumColorImmutable(this.red * multiplier, this.green * multiplier, this.blue * multiplier, this.alpha);
    }

    @Override
    @NotNull
    public AtumColorImmutable invert() {
        return new AtumColorImmutable(1.0f - this.red, 1.0f - this.green, 1.0f - this.blue, this.alpha);
    }

    @Override
    @NotNull
    public AtumColorImmutable toGrayscale() {
        float luminance = 0.3f * this.red + 0.59f * this.green + 0.11f * this.blue;
        return new AtumColorImmutable(luminance, luminance, luminance, this.alpha);
    }

    @Override
    @NotNull
    public AtumColorImmutable withAlpha(float newAlpha) {
        return new AtumColorImmutable(this.red, this.green, this.blue, newAlpha);
    }

    @Override
    public double getContrastRatio(@NotNull AtumColor other) {
        double l1 = this.relativeLuminance(this);
        double l2 = this.relativeLuminance(other);
        double lighter = Math.max(l1, l2);
        double darker = Math.min(l1, l2);
        return (lighter + 0.05) / (darker + 0.05);
    }

    private double relativeLuminance(AtumColor color) {
        double r = this.adjust(color.getRed());
        double g = this.adjust(color.getGreen());
        double b = this.adjust(color.getBlue());
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private double adjust(double channel) {
        return channel <= 0.03928 ? channel / 12.92 : Math.pow((channel + 0.055) / 1.055, 2.4);
    }

    public AtumColorMutable asMutable() {
        return new AtumColorMutable(this.red, this.green, this.blue, this.alpha);
    }

    public String toString() {
        return "AtumColorImmutable{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtumColor)) {
            return false;
        }
        AtumColor that = (AtumColor)o;
        return Float.compare(that.getRed(), this.red) == 0 && Float.compare(that.getGreen(), this.green) == 0 && Float.compare(that.getBlue(), this.blue) == 0 && Float.compare(that.getAlpha(), this.alpha) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
    }

    @Override
    public float getRed() {
        return this.red;
    }

    @Override
    public float getGreen() {
        return this.green;
    }

    @Override
    public float getBlue() {
        return this.blue;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int getRedInt() {
        return this.redInt;
    }

    @Override
    public int getGreenInt() {
        return this.greenInt;
    }

    @Override
    public int getBlueInt() {
        return this.blueInt;
    }

    @Override
    public int getAlphaInt() {
        return this.alphaInt;
    }
}

