/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.api.utils;

import java.util.concurrent.ThreadLocalRandom;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import org.joml.Matrix4f;

public class MathUtils {
    private static final double[] SIN_LOOKUP;
    private static final double[] ASIN_TAB;
    private static final double[] COS_TAB;
    private static final double FRAC_BIAS;
    public static final double degreesToRadians = Math.PI / 180;

    private MathUtils() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static double fastSin(double radians) {
        float f = (float)radians;
        return SIN_LOOKUP[(int)(f * 10430.378f) & 0xFFFF];
    }

    public static double fastCos(double radians) {
        float f = (float)radians;
        return SIN_LOOKUP[(int)(f * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static double fastTan(double radians) {
        float f = (float)radians;
        return SIN_LOOKUP[(int)(f * 10430.378f) & 0xFFFF] / SIN_LOOKUP[(int)(f * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static double fastAtan2(double d, double e) {
        double g;
        boolean bl3;
        boolean bl2;
        boolean bl;
        double f = e * e + d * d;
        if (Double.isNaN(f)) {
            return Double.NaN;
        }
        boolean bl4 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        boolean bl5 = bl2 = e < 0.0;
        if (bl2) {
            e = -e;
        }
        boolean bl6 = bl3 = d > e;
        if (bl3) {
            g = e;
            e = d;
            d = g;
        }
        g = MathUtils.fastInvSqrt(f);
        e *= g;
        double h = FRAC_BIAS + (d *= g);
        int i = (int)Double.doubleToRawLongBits(h);
        double j = ASIN_TAB[i];
        double k = COS_TAB[i];
        double l = h - FRAC_BIAS;
        double m = d * k - e * l;
        double n = (6.0 + m * m) * m * 0.16666666666666666;
        double o = j + n;
        if (bl3) {
            o = 1.5707963267948966 - o;
        }
        if (bl2) {
            o = Math.PI - o;
        }
        if (bl) {
            o = -o;
        }
        return o;
    }

    public static double fastInvSqrt(double d) {
        double e = 0.5 * d;
        long l = Double.doubleToRawLongBits(d);
        l = 6910469410427058090L - (l >> 1);
        d = Double.longBitsToDouble(l);
        d *= 1.5 - e * d * d;
        return d;
    }

    public static float fastInvCubeRoot(float f) {
        int i = Float.floatToIntBits(f);
        i = 1419967116 - i / 3;
        float g = Float.intBitsToFloat(i);
        g = 0.6666667f * g + 1.0f / (3.0f * g * g * f);
        g = 0.6666667f * g + 1.0f / (3.0f * g * g * f);
        return g;
    }

    public static double bias(double input, double bias) {
        double k = Math.pow(1.0 - bias, 3.0);
        return input * k / (input * k - input + 1.0);
    }

    public static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static double randDouble(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static PairRecord<Integer, Integer> getAspectRatio(int a, int b) {
        int gcd = MathUtils.getGCD(a, b);
        int aspectRatioWidth = a / gcd;
        int aspectRatioHeight = b / gcd;
        return new PairRecord<Integer, Integer>(aspectRatioWidth, aspectRatioHeight);
    }

    private static int getGCD(int a, int b) {
        while (b != 0) {
            int temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    public static Matrix4f extractRotationFromPose(Matrix4f pose) {
        Matrix4f rotation = new Matrix4f();
        rotation.set(0, 0, pose.get(0, 0));
        rotation.set(0, 1, pose.get(0, 1));
        rotation.set(0, 2, pose.get(0, 2));
        rotation.set(0, 3, 0.0f);
        rotation.set(1, 0, pose.get(1, 0));
        rotation.set(1, 1, pose.get(1, 1));
        rotation.set(1, 2, pose.get(1, 2));
        rotation.set(1, 3, 0.0f);
        rotation.set(2, 0, pose.get(2, 0));
        rotation.set(2, 1, pose.get(2, 1));
        rotation.set(2, 2, pose.get(2, 2));
        rotation.set(2, 3, 0.0f);
        rotation.set(3, 0, 0.0f);
        rotation.set(3, 1, 0.0f);
        rotation.set(3, 2, 0.0f);
        rotation.set(3, 3, 1.0f);
        return rotation;
    }

    static {
        int i;
        SIN_LOOKUP = new double[65536];
        ASIN_TAB = new double[257];
        COS_TAB = new double[257];
        FRAC_BIAS = Double.longBitsToDouble(4805340802404319232L);
        for (i = 0; i < 65536; ++i) {
            MathUtils.SIN_LOOKUP[i] = Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
        for (i = 0; i < 257; ++i) {
            double d = (double)i / 256.0;
            double e = Math.asin(d);
            MathUtils.COS_TAB[i] = Math.cos(e);
            MathUtils.ASIN_TAB[i] = e;
        }
    }
}

