/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core;

import java.nio.ByteBuffer;
import java.util.List;
import me.phoenixra.atumvr.api.VRLogger;
import me.phoenixra.atumvr.api.VRProvider;
import me.phoenixra.atumvr.api.exceptions.VRException;
import me.phoenixra.atumvr.api.rendering.IRenderContext;
import me.phoenixra.atumvr.api.rendering.VRRenderer;
import me.phoenixra.atumvr.core.OpenXRState;
import me.phoenixra.atumvr.core.enums.XRActionResult;
import me.phoenixra.atumvr.core.enums.XRSessionStateChange;
import me.phoenixra.atumvr.core.input.OpenXRInputHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class OpenXRProvider
implements VRProvider {
    private final String appName;
    private final VRLogger logger;
    protected OpenXRState state;
    protected OpenXRInputHandler inputHandler;
    protected VRRenderer renderer;
    protected long xrDisplayTime;

    public OpenXRProvider(@NotNull String appName, @NotNull VRLogger logger) {
        this.appName = appName;
        this.logger = logger;
        this.state = this.createStateHandler();
        this.renderer = this.createRenderer();
        this.inputHandler = this.createInputHandler();
    }

    @Nullable
    public abstract OpenXRState createStateHandler();

    @Nullable
    public abstract OpenXRInputHandler createInputHandler();

    @NotNull
    public abstract VRRenderer createRenderer();

    public abstract void onStateChanged(XRSessionStateChange var1);

    public List<String> getXRAppExtensions() {
        return List.of("XR_EXT_hp_mixed_reality_controller", "XR_HTC_vive_cosmos_controller_interaction", "XR_BD_controller_interaction");
    }

    public List<Integer> getSwapChainFormats() {
        return List.of(Integer.valueOf(35907), Integer.valueOf(35905), Integer.valueOf(32857), Integer.valueOf(34842), Integer.valueOf(34843), Integer.valueOf(32856), Integer.valueOf(36759));
    }

    @Override
    public void initializeVR() throws Throwable {
        if (this.state.isInitialized()) {
            throw new VRException("Already initialized!");
        }
        this.state.init();
    }

    @Override
    public void syncState() {
        this.state.pollVREvents();
    }

    @Override
    public void preRender(@NotNull IRenderContext context) {
        if (!this.state.running) {
            return;
        }
        this.renderer.preRender(context);
        this.inputHandler.update();
    }

    @Override
    public void render(@NotNull IRenderContext context) {
        if (!this.state.running) {
            return;
        }
        this.renderer.renderFrame(context);
    }

    @Override
    public void postRender(@NotNull IRenderContext context) {
    }

    public void checkXRError(int xrResult, String caller, String ... args) throws VRException {
        this.checkXRError(true, xrResult, caller, args);
    }

    public void checkXRError(boolean throwError, int xrResult, String caller, String ... args) throws VRException {
        if (xrResult < 0) {
            String msg = String.format("%s for %s error: %s", caller, String.join((CharSequence)" ", args), this.getXRActionResult(xrResult));
            if (!throwError) {
                this.logger.logError(msg);
                return;
            }
            throw new VRException(msg);
        }
    }

    public String getXRActionResult(int resultId) {
        Object resultString;
        XRActionResult result = XRActionResult.fromId(resultId);
        Object object = resultString = result != null ? result.toString() : null;
        if (resultString == null) {
            if (this.state.vrInstance == null) {
                return "Unknown XR Action Result: " + resultId;
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer str = stack.calloc(64);
                resultString = XR10.xrResultToString((XrInstance)this.state.vrInstance.getHandle(), (int)resultId, (ByteBuffer)str) == 0 ? MemoryUtil.memUTF8((long)MemoryUtil.memAddress((ByteBuffer)str)) : "Unknown XR Action Result: " + resultId;
            }
        }
        return resultString;
    }

    @Override
    public void destroy() {
        if (this.renderer != null) {
            this.renderer.destroy();
        }
        if (this.inputHandler != null) {
            this.inputHandler.destroy();
        }
        this.state.destroy();
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public VRLogger getLogger() {
        return this.logger;
    }

    @Override
    public OpenXRState getState() {
        return this.state;
    }

    @Override
    public OpenXRInputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public VRRenderer getRenderer() {
        return this.renderer;
    }

    public long getXrDisplayTime() {
        return this.xrDisplayTime;
    }

    public void setXrDisplayTime(long xrDisplayTime) {
        this.xrDisplayTime = xrDisplayTime;
    }
}

