/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core;

import java.util.ArrayList;
import java.util.List;
import me.phoenixra.atumvr.api.VRState;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XREvent;
import me.phoenixra.atumvr.core.enums.XRSessionStateChange;
import me.phoenixra.atumvr.core.init.OpenXRInstance;
import me.phoenixra.atumvr.core.init.OpenXRSession;
import me.phoenixra.atumvr.core.init.OpenXRSwapChain;
import me.phoenixra.atumvr.core.init.OpenXRSystem;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.openxr.XrEventDataBuffer;
import org.lwjgl.openxr.XrEventDataSessionStateChanged;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSessionBeginInfo;
import org.lwjgl.system.MemoryStack;

public class OpenXRState
implements VRState {
    private final OpenXRProvider vrProvider;
    protected OpenXRInstance vrInstance;
    protected OpenXRSystem vrSystem;
    protected OpenXRSession vrSession;
    protected OpenXRSwapChain vrSwapChain;
    protected final List<XREvent> xrEventsReceived = new ArrayList<XREvent>();
    protected boolean running = false;
    protected boolean active = false;
    protected boolean focused = false;
    protected boolean initialized = false;

    public OpenXRState(OpenXRProvider vrProvider) {
        this.vrProvider = vrProvider;
    }

    public void init() throws Throwable {
        this.vrInstance = new OpenXRInstance(this);
        this.vrSystem = new OpenXRSystem(this);
        this.vrSession = new OpenXRSession(this);
        this.vrSwapChain = new OpenXRSwapChain(this);
        this.vrInstance.init();
        this.vrSystem.init();
        this.vrSession.init();
        this.vrSwapChain.init();
        while (!this.running) {
            this.vrProvider.getLogger().logInfo("Waiting for OpenXR session to start...");
            this.pollVREvents();
        }
        this.vrProvider.inputHandler.init();
        this.vrProvider.renderer.init();
        this.initialized = true;
    }

    protected void pollVREvents() {
        this.xrEventsReceived.clear();
        XrEventDataBuffer eventBuffer = this.vrInstance.getXrEventBuffer();
        while (true) {
            eventBuffer.clear();
            eventBuffer.type(16);
            int error = XR10.xrPollEvent((XrInstance)this.vrInstance.getHandle(), (XrEventDataBuffer)eventBuffer);
            this.vrProvider.checkXRError(error, "xrPollEvent", "");
            if (error != 0) break;
            XrEventDataBaseHeader event = XrEventDataBaseHeader.create((long)eventBuffer.address());
            XREvent vrEvent = XREvent.fromId(event.type());
            if (vrEvent == XREvent.SESSION_STATE_CHANGED) {
                this.xrStateChanged(XrEventDataSessionStateChanged.create((long)event.address()));
                continue;
            }
            this.xrEventsReceived.add(vrEvent);
        }
    }

    private void xrStateChanged(XrEventDataSessionStateChanged event) {
        XRSessionStateChange stateChange = XRSessionStateChange.fromId(event.state());
        this.vrProvider.getLogger().logDebug("VR Session State changed to: " + stateChange);
        switch (stateChange) {
            case READY: {
                try (MemoryStack stack = MemoryStack.stackPush();){
                    XrSessionBeginInfo sessionBeginInfo = XrSessionBeginInfo.calloc((MemoryStack)stack).type(10).next(0L).primaryViewConfigurationType(2);
                    this.vrProvider.checkXRError(XR10.xrBeginSession((XrSession)this.vrSession.getHandle(), (XrSessionBeginInfo)sessionBeginInfo), "xrBeginSession", "XRStateChangeREADY");
                }
                this.running = true;
                this.active = true;
                this.vrProvider.getLogger().logInfo("OpenXR session is READY");
                break;
            }
            case STOPPING: {
                this.running = false;
                this.active = false;
                break;
            }
            case VISIBLE: 
            case FOCUSED: {
                this.active = true;
                break;
            }
            case EXITING: 
            case IDLE: 
            case SYNCHRONIZED: {
                this.active = false;
            }
        }
        this.focused = stateChange == XRSessionStateChange.FOCUSED;
        this.vrProvider.onStateChanged(stateChange);
    }

    public int getEyeTexWidth() {
        return this.vrSwapChain.getEyeMaxWidth();
    }

    public int getEyeTexHeight() {
        return this.vrSwapChain.getEyeMaxHeight();
    }

    public void destroy() {
        if (this.vrSwapChain != null) {
            this.vrSwapChain.destroy();
        }
        if (this.vrSession != null) {
            this.vrSession.destroy();
        }
        if (this.vrSystem != null) {
            this.vrSystem.destroy();
        }
        if (this.vrInstance != null) {
            this.vrInstance.destroy();
        }
        this.xrEventsReceived.clear();
        this.running = false;
        this.active = false;
        this.focused = false;
        this.initialized = false;
    }

    @Override
    public OpenXRProvider getVrProvider() {
        return this.vrProvider;
    }

    public OpenXRInstance getVrInstance() {
        return this.vrInstance;
    }

    public OpenXRSystem getVrSystem() {
        return this.vrSystem;
    }

    public OpenXRSession getVrSession() {
        return this.vrSession;
    }

    public OpenXRSwapChain getVrSwapChain() {
        return this.vrSwapChain;
    }

    public List<XREvent> getXrEventsReceived() {
        return this.xrEventsReceived;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }
}

