/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.init.OpenXRInstance;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.atumvr.core.input.action.profileset.types.HpMixedRealitySet;
import me.phoenixra.atumvr.core.input.action.profileset.types.OculusTouchSet;
import me.phoenixra.atumvr.core.input.action.profileset.types.ValveIndexSet;
import me.phoenixra.atumvr.core.input.action.profileset.types.ViveCosmosSet;
import me.phoenixra.atumvr.core.input.action.profileset.types.ViveSet;
import me.phoenixra.atumvr.core.input.action.profileset.types.WindowsMotionSet;

public enum XRInteractionProfile {
    VALVE_INDEX("/interaction_profiles/valve/index_controller"),
    OCULUS_TOUCH("/interaction_profiles/oculus/touch_controller"),
    VIVE("/interaction_profiles/htc/vive_controller"),
    VIVE_COSMOS("/interaction_profiles/htc/vive_cosmos_controller"),
    HP_MIXED_REALITY("/interaction_profiles/hp/mixed_reality_controller"),
    WINDOWS_MOTION("/interaction_profiles/microsoft/motion_controller");

    private final String pathName;
    private static final HashMap<String, XRInteractionProfile> values;

    private XRInteractionProfile(String pathName) {
        this.pathName = pathName;
    }

    public static XRInteractionProfile fromPath(String path) {
        if (values.isEmpty()) {
            for (XRInteractionProfile entry : XRInteractionProfile.values()) {
                values.put(entry.pathName, entry);
            }
        }
        return values.get(path);
    }

    public static List<XRInteractionProfile> getSupported(OpenXRProvider provider) {
        ArrayList<XRInteractionProfile> list = new ArrayList<XRInteractionProfile>();
        OpenXRInstance instance = provider.getState().getVrInstance();
        list.add(OCULUS_TOUCH);
        list.add(VALVE_INDEX);
        list.add(WINDOWS_MOTION);
        list.add(VIVE);
        if (instance.getHandle().getCapabilities().XR_EXT_hp_mixed_reality_controller) {
            list.add(HP_MIXED_REALITY);
        }
        if (instance.getHandle().getCapabilities().XR_HTC_vive_cosmos_controller_interaction) {
            list.add(VIVE_COSMOS);
        }
        return list;
    }

    public static List<OpenXRProfileSet> getSupportedProfileSets(OpenXRProvider provider) {
        ArrayList<OpenXRProfileSet> out = new ArrayList<OpenXRProfileSet>();
        List<XRInteractionProfile> supported = XRInteractionProfile.getSupported(provider);
        if (supported.contains((Object)VALVE_INDEX)) {
            out.add(new ValveIndexSet(provider));
        }
        if (supported.contains((Object)OCULUS_TOUCH)) {
            out.add(new OculusTouchSet(provider));
        }
        if (supported.contains((Object)WINDOWS_MOTION)) {
            out.add(new WindowsMotionSet(provider));
        }
        if (supported.contains((Object)HP_MIXED_REALITY)) {
            out.add(new HpMixedRealitySet(provider));
        }
        if (supported.contains((Object)VIVE)) {
            out.add(new ViveSet(provider));
        }
        if (supported.contains((Object)VIVE_COSMOS)) {
            out.add(new ViveCosmosSet(provider));
        }
        return out;
    }

    public String getPathName() {
        return this.pathName;
    }

    static {
        values = new HashMap();
    }
}

